/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.db.DBAccess;
import org.eclnt.ccee.db.dofw.DOFWEntity;
import org.eclnt.ccee.log.AppLog;

public abstract class DBAction
implements ICCEEConstants {
    String m_contextName = "CCEE_DEFAULTCONTEXT";
    Connection m_connection;
    boolean m_createdConnetion = false;
    boolean m_commitRequired = true;
    String m_explicitSchema = null;
    List<PreparedStatement> m_statements = new ArrayList<PreparedStatement>();
    Map<String, PreparedStatement> m_batchStatementReference = new HashMap<String, PreparedStatement>();
    String m_currentStatementForErrorMessage;
    boolean m_isolatedAction = false;

    public DBAction() {
        this.process("CCEE_DEFAULTCONTEXT");
    }

    public DBAction(String contextName) {
        this.process(contextName);
    }

    public void noWarning() {
    }

    protected final void process(String contextName) {
        this.m_contextName = contextName;
        try {
            this.beforeQuery();
            this.run();
            this.afterQuery();
        }
        catch (Throwable t) {
            try {
                this.rollback();
            }
            catch (Throwable tt) {
                throw new Error(tt);
            }
            if (this.m_currentStatementForErrorMessage == null) {
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new Error(t);
            }
            throw new Error("Error occurred during processing of DBAction. Statement was: " + this.m_currentStatementForErrorMessage, t);
        }
        finally {
            try {
                this.inFinally();
            }
            catch (Throwable tt) {
                throw new Error(tt);
            }
        }
    }

    protected abstract void run() throws Exception;

    protected final void addCommitRunnable(Runnable r) {
        DBAccess.addCommitRunnable(r);
    }

    public final String withSchema(String tableName) {
        if (this.m_explicitSchema == null) {
            return tableName;
        }
        if (tableName.contains(".")) {
            return tableName;
        }
        return this.m_explicitSchema + "." + tableName;
    }

    public final String withSchema(DOFWEntity entity) {
        String tableName = entity.getTable();
        if (entity.getSchema() != null) {
            return entity.getSchema() + "." + tableName;
        }
        String result = this.withSchema(tableName);
        return result;
    }

    public final PreparedStatement createStatement(String query) {
        try {
            AppLog.L.log(LL_INF, "SQL: \n" + query);
            this.m_currentStatementForErrorMessage = query;
            PreparedStatement ps = this.m_connection.prepareStatement(query);
            this.m_statements.add(ps);
            return ps;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public final Connection getConnection() {
        return this.m_connection;
    }

    public final PreparedStatement createStatement(String query, int autoGeneratedKeys) {
        try {
            AppLog.L.log(LL_INF, "SQL: \n" + query);
            this.m_currentStatementForErrorMessage = query;
            PreparedStatement ps = this.m_connection.prepareStatement(query, autoGeneratedKeys);
            this.m_statements.add(ps);
            return ps;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public final PreparedStatement createBatchStatement(String query) {
        try {
            AppLog.L.log(LL_INF, "SQL: \n" + query);
            PreparedStatement ps = this.m_batchStatementReference.get(query);
            if (ps == null) {
                ps = this.createStatement(query);
                this.m_batchStatementReference.put(query, ps);
            }
            return ps;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    void afterQuery() throws Exception {
        if (this.m_commitRequired) {
            DBAccess.commitConnection(this.m_contextName);
        }
    }

    void beforeQuery() throws Exception {
        DBAccess.PickConnectionResult pcr = this.pickConnection();
        this.m_connection = pcr.connection;
        this.m_createdConnetion = pcr.wasCreated;
        this.m_explicitSchema = pcr.explicitSchema;
    }

    DBAccess.PickConnectionResult pickConnection() throws Exception {
        DBAccess.PickConnectionResult pcr = DBAccess.pickConnection(this, this.m_contextName);
        return pcr;
    }

    void rollback() throws Exception {
        if (this.m_connection != null) {
            DBAccess.rollbackConnection();
        }
    }

    void inFinally() throws Exception {
        this.closeStatements();
        if (this.m_createdConnetion) {
            DBAccess.closeConnection(this);
        }
    }

    void closeStatements() {
        for (PreparedStatement ps : this.m_statements) {
            try {
                ps.close();
            }
            catch (Throwable t) {
                AppLog.L.log(LL_WAR, "Problem closing statement", t);
            }
        }
    }
}

