/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.dofw;

import java.util.HashMap;
import java.util.Map;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.bridges.ClassLoaderBridge;
import org.eclnt.ccee.config.Config;
import org.eclnt.ccee.db.IDBConnectionPasswordProvider;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.jsfserver.managedbean.DefaultHotDeployListener;
import org.eclnt.jsfserver.managedbean.HotDeployNotifier;
import org.eclnt.jsfserver.managedbean.IHotDeployListener;

public class DBConnectionPasswordProviderManager
implements ICCEEConstants {
    static final Object SYNCHER = new Object();
    static final Map<String, IDBConnectionPasswordProvider> s_passwordProviders = new HashMap<String, IDBConnectionPasswordProvider>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDBConnectionPasswordProvider findDBConnectionPasswordProvider(String contextName) {
        String className = Config.getConfigValue(contextName, "db_connectionpasswordproviderclassname");
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            IDBConnectionPasswordProvider provider = null;
            Object object = SYNCHER;
            synchronized (object) {
                provider = s_passwordProviders.get(contextName);
            }
            if (provider == null) {
                object = SYNCHER;
                synchronized (object) {
                    provider = s_passwordProviders.get(contextName);
                    if (provider == null) {
                        Class<?> providerClass = Class.forName(className, true, ClassLoaderBridge.findCurrentClassLoader());
                        provider = (IDBConnectionPasswordProvider)providerClass.newInstance();
                        s_passwordProviders.put(contextName, provider);
                    }
                }
            }
            return provider;
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Problem accesing connection password provider " + className, t);
            throw new Error(t);
        }
    }

    static {
        HotDeployNotifier.addListener((IHotDeployListener)new DefaultHotDeployListener(){

            public void onClassLoaderUpdate(ClassLoader newClassLoader) {
                s_passwordProviders.clear();
            }
        });
    }
}

