/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.dofw;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclnt.ccee.db.dofw.DOFWEntity;
import org.eclnt.ccee.db.dofw.DOFWProperty;
import org.eclnt.ccee.db.dofw.annotations.ENUMTrim;
import org.eclnt.ccee.db.dofw.annotations.doentity;
import org.eclnt.ccee.db.dofw.annotations.doproperty;
import org.eclnt.jsfserver.managedbean.DefaultHotDeployListener;
import org.eclnt.jsfserver.managedbean.HotDeployNotifier;
import org.eclnt.jsfserver.managedbean.IHotDeployListener;
import org.eclnt.util.valuemgmt.ValueManager;

public class DOFWRepository {
    static IOverrideContent s_overrideContent = null;
    static Map<Class, List<DOFWProperty>> s_propertiesPerClass = new Hashtable<Class, List<DOFWProperty>>();
    static Map<Class, DOFWEntity> s_classes = new Hashtable<Class, DOFWEntity>();
    static final Object SYNCHER = new Object();

    public static void initializeOverrideContent(IOverrideContent or) {
        s_overrideContent = or;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetBuffers() {
        Object object = SYNCHER;
        synchronized (object) {
            s_propertiesPerClass.clear();
            s_classes.clear();
        }
    }

    public static DOFWEntity getEntity(Class doClass) {
        DOFWRepository.analyseClass(doClass);
        return s_classes.get(doClass);
    }

    public static DOFWEntity getEntity(Class doClass, boolean withError) {
        DOFWEntity result = DOFWRepository.getEntity(doClass);
        if (result == null && withError) {
            throw new Error("Could not find entity information for class: " + doClass.getName());
        }
        return result;
    }

    public static List<DOFWProperty> getProperties(Class doClass) {
        DOFWRepository.analyseClass(doClass);
        return s_propertiesPerClass.get(doClass);
    }

    public static DOFWProperty getProperty(Class doClass, String propertyName) {
        DOFWRepository.analyseClass(doClass);
        List<DOFWProperty> ps = DOFWRepository.getProperties(doClass);
        for (DOFWProperty p : ps) {
            String getterName = p.getGetter().getName().toLowerCase();
            if (getterName.equalsIgnoreCase("get" + propertyName)) {
                return p;
            }
            if (!getterName.equalsIgnoreCase("is" + propertyName)) continue;
            return p;
        }
        return null;
    }

    public static DOFWProperty getProperty(Class doClass, String propertyName, boolean withError) {
        DOFWProperty result = DOFWRepository.getProperty(doClass, propertyName);
        if (result == null && withError) {
            throw new Error("Could not find property information for property: " + doClass.getName() + "/" + propertyName);
        }
        return result;
    }

    public static List<DOFWProperty> getKeyProperties(Class doClass) {
        DOFWRepository.analyseClass(doClass);
        List<DOFWProperty> result = s_propertiesPerClass.get(doClass);
        result = new ArrayList<DOFWProperty>(result);
        for (int i = result.size() - 1; i >= 0; --i) {
            if (result.get(i).isKey()) continue;
            result.remove(i);
        }
        return result;
    }

    public static List<DOFWProperty> getKeyPropertiesSorted(Class doClass) {
        List<DOFWProperty> keyProps = DOFWRepository.getKeyProperties(doClass);
        Collections.sort(keyProps, new Comparator<DOFWProperty>(){

            @Override
            public int compare(DOFWProperty o1, DOFWProperty o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return keyProps;
    }

    public static boolean checkIfClassContainsPropertiesWithOnlyReadWithSingleReadOperations(Class doClass) {
        List<DOFWProperty> properties = DOFWRepository.getValueProperties(doClass);
        for (DOFWProperty property : properties) {
            if (!property.getOnlyReadWithSingleReadOperations()) continue;
            return true;
        }
        return false;
    }

    public static List<DOFWProperty> getValueProperties(Class doClass) {
        DOFWRepository.analyseClass(doClass);
        List<DOFWProperty> result = s_propertiesPerClass.get(doClass);
        result = new ArrayList<DOFWProperty>(result);
        for (int i = result.size() - 1; i >= 0; --i) {
            if (!result.get(i).isKey()) continue;
            result.remove(i);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void analyseClass(Class doClass) {
        if (s_classes.containsKey(doClass)) {
            return;
        }
        Object object = SYNCHER;
        synchronized (object) {
            if (s_classes.containsKey(doClass)) {
                return;
            }
            try {
                Method[] ms;
                doentity doe = doClass.getAnnotation(doentity.class);
                if (doe == null) {
                    throw new Error("Missing annotation @doentity in class: " + doClass + ". This annotation must be present to use the class within the DOFW framework.");
                }
                String tableName = doe.table();
                if ("UNDEFINED".equals(tableName)) {
                    tableName = doClass.getSimpleName();
                }
                DOFWEntity e = new DOFWEntity(tableName, doe.schema(), doe.tenantColumn(), doe.tenantIsNumeric(), doe.buffered(), doe.isView(), doe.deletedProperty(), doe.traceActive(), doe.isTransient());
                if (s_overrideContent != null) {
                    s_overrideContent.updateEntityDuringAnalysis(doClass, e);
                }
                ArrayList<DOFWProperty> result = new ArrayList<DOFWProperty>();
                for (Method m : ms = doClass.getMethods()) {
                    DOFWProperty p = null;
                    if (s_overrideContent != null && m.getName().startsWith("get") && m.getParameterCount() == 0) {
                        p = s_overrideContent.createPropertyForGetter(doClass, m);
                    }
                    if (p == null && m.isAnnotationPresent(doproperty.class)) {
                        doproperty dop = m.getAnnotation(doproperty.class);
                        Method setter = DOFWRepository.findSetter(doClass, m);
                        String propertyName = Introspector.decapitalize(m.getName().substring(3));
                        String colName = dop.column();
                        if ("UNDEFINED".equals(colName)) {
                            colName = setter.getName().substring(3);
                            colName = Introspector.decapitalize(colName);
                        }
                        p = DOFWRepository.createDOFWProperty(doClass, propertyName, m, setter, colName, dop);
                    }
                    if (p == null) continue;
                    result.add(p);
                }
                Field[] fs = doClass.getDeclaredFields();
                for (Field f : fs) {
                    if (!f.isAnnotationPresent(doproperty.class)) continue;
                    String fieldName = f.getName();
                    if (fieldName.startsWith("m_")) {
                        fieldName = fieldName.substring(2);
                    }
                    doproperty dop = f.getAnnotation(doproperty.class);
                    Method getter = DOFWRepository.findGetter(doClass, fieldName);
                    Method setter = DOFWRepository.findSetter(doClass, getter);
                    String colName = dop.column();
                    if ("UNDEFINED".equals(colName)) {
                        colName = setter.getName().substring(3);
                        colName = Introspector.decapitalize(colName);
                    }
                    DOFWProperty p = DOFWRepository.createDOFWProperty(doClass, fieldName, getter, setter, colName, dop);
                    result.add(p);
                }
                if (s_overrideContent != null) {
                    for (DOFWProperty p : result) {
                        s_overrideContent.updatePropertyDuringClassAnalysis(doClass, p);
                    }
                }
                s_propertiesPerClass.put(doClass, result);
                s_classes.put(doClass, e);
            }
            catch (Throwable t) {
                throw new Error("problem when analyzing class: " + doClass, t);
            }
        }
    }

    private static DOFWProperty createDOFWProperty(Class entityClass, String name, Method getter, Method setter, String colName, doproperty dop) {
        Boolean trimBoolean = null;
        if (dop.trim() == ENUMTrim.trim) {
            trimBoolean = true;
        } else if (dop.trim() == ENUMTrim.notrim) {
            trimBoolean = false;
        }
        DOFWProperty p = new DOFWProperty(entityClass, name, getter, setter, colName, dop.key(), dop.boolean2int(), dop.boolean2StringX(), dop.date2long(), dop.date2longYYYYMMDD(), dop.localDate2longYYYYMMDD(), dop.YYMMDDCenturyReference(), trimBoolean, dop.string2bytes64(), dop.string2bytesHEX(), dop.uuid2string(), dop.autoIncrement(), dop.autoIncrementExcludeFromUpdate(), dop.onlyReadWithSingleReadOperations(), dop.date2longYYMMDD(), dop.localDate2longYYMMDD(), dop.boolean2StringJN(), dop.boolean2StringYN(), dop.boolean2StringDefault(), dop.dbNullValue());
        return p;
    }

    private static Method findGetter(Class doClass, String name) throws Exception {
        try {
            name = ValueManager.toUpperCaseId((String)name.substring(0, 1)) + name.substring(1);
            String nameGet = "get" + name;
            Method m = doClass.getMethod(nameGet, null);
            return m;
        }
        catch (NoSuchMethodException | SecurityException nse) {
            try {
                String nameIs = "is" + name;
                Method m = doClass.getMethod(nameIs, null);
                return m;
            }
            catch (NoSuchMethodException | SecurityException nse2) {
                throw nse;
            }
            catch (Throwable t2) {
                throw new Error("Problem when resolving the getter-method: " + doClass.getName() + ", " + name, t2);
            }
        }
        catch (Throwable t) {
            throw new Error("Problem when resolving the getter-method: " + doClass.getName() + ", " + name, t);
        }
    }

    private static Method findSetter(Class doClass, Method getter) {
        String getterName = getter.getName();
        try {
            String setterName = null;
            if (getterName.startsWith("get")) {
                setterName = "set" + getterName.substring(3);
            } else if (getterName.startsWith("is")) {
                setterName = "set" + getterName.substring(2);
            } else {
                throw new Error("Can not find setter for getter: " + getterName);
            }
            Method result = doClass.getMethod(setterName, getter.getReturnType());
            return result;
        }
        catch (Throwable t) {
            throw new Error("Problem when resolving the setter-method: " + doClass.getName() + ", " + getter.getName(), t);
        }
    }

    static {
        HotDeployNotifier.addListener((IHotDeployListener)new DefaultHotDeployListener(){

            public void onClassLoaderUpdate(ClassLoader newClassLoader) {
                s_propertiesPerClass.clear();
                s_classes.clear();
            }
        });
    }

    public static class DefaultOverrideContent
    implements IOverrideContent {
        @Override
        public DOFWProperty createPropertyForGetter(Class clazz, Method getter) {
            return null;
        }

        @Override
        public void updatePropertyDuringClassAnalysis(Class clazz, DOFWProperty property) {
        }

        @Override
        public void updateEntityDuringAnalysis(Class doClass, DOFWEntity e) {
        }
    }

    public static interface IOverrideContent {
        public DOFWProperty createPropertyForGetter(Class var1, Method var2);

        public void updatePropertyDuringClassAnalysis(Class var1, DOFWProperty var2);

        public void updateEntityDuringAnalysis(Class var1, DOFWEntity var2);
    }
}

