/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.dofw.util;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Base64;
import java.util.Calendar;
import java.util.UUID;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.db.DBAccess;
import org.eclnt.ccee.db.dofw.DOFWDialect;
import org.eclnt.ccee.db.dofw.DOFWProperty;
import org.eclnt.ccee.db.dofw.ISimpleDataTypeExtensionDOFW;
import org.eclnt.ccee.db.dofw.annotations.ENUMBooleanDefault;
import org.eclnt.ccee.db.dofw.util.ENUMMappingInfo;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ISimpleDataTypeExtension;
import org.eclnt.util.valuemgmt.ValueManager;

public class DOFWMapper
implements ICCEEConstants {
    public static final Object NOVALUEAVAILABLE = new Object();

    public static void mapDBValue2PropertyValue(String contextName, ResultSet rs, Object dob, DOFWProperty property) {
        try {
            Object value = DOFWMapper.readAndMapDBValue(contextName, rs, property.getColumn(), property);
            if (value != NOVALUEAVAILABLE) {
                Method setter = property.getSetter();
                setter.invoke(dob, value);
            }
        }
        catch (Throwable t) {
            throw new Error("Error during mapping of " + property.getGetter().getName(), t);
        }
    }

    public static Object readAndMapDBValue(String contextName, ResultSet rs, String columnName, DOFWProperty property) {
        int columnIndex = -1;
        try {
            columnIndex = rs.findColumn(columnName);
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "The column " + columnName + "is mapped to property " + property.getName() + " - but the column is not avaiable.");
            return NOVALUEAVAILABLE;
        }
        try {
            return DOFWMapper.readAndMapDBValue(contextName, rs, columnIndex, property);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static Object readAndMapDBValue(String contextName, ResultSet rs, int columnIndex, DOFWProperty property) {
        try {
            Object value = rs.getObject(columnIndex);
            if (value != null && property.getDbNullValue() != null && value.equals(property.getDbNullValue())) {
                value = null;
            }
            Class<?> propType = property.getType();
            if (value == null) {
                if (propType == Integer.TYPE) {
                    return 0;
                }
                if (propType == Short.TYPE) {
                    return (short)0;
                }
                if (propType == Byte.TYPE) {
                    return (byte)0;
                }
                if (propType == Long.TYPE) {
                    return 0L;
                }
                if (propType == Float.TYPE) {
                    return Float.valueOf(0.0f);
                }
                if (propType == Double.TYPE) {
                    return 0.0;
                }
                if (propType == Boolean.TYPE) {
                    if (property.getBoolean2StringDefault() == ENUMBooleanDefault.TRUE) {
                        return true;
                    }
                    return false;
                }
                if (propType == Boolean.class && (property.getBoolean2StringJN() || property.getBoolean2StringYN() || property.getBoolean2StringX())) {
                    if (property.getBoolean2StringDefault() == ENUMBooleanDefault.TRUE) {
                        return true;
                    }
                    if (property.getBoolean2StringDefault() == ENUMBooleanDefault.NULL) {
                        return null;
                    }
                    return false;
                }
                if (propType == Character.TYPE) {
                    return Character.valueOf('\u0000');
                }
                try {
                    Object result = DOFWMapper.readAndMapDBValueViaSimpleDataTypeExtension(value, property, rs, columnIndex, propType);
                    return result;
                }
                catch (Exception result) {
                    return value;
                }
            }
            if (propType == String.class && !property.getString2bytes64() && !property.getString2bytesHEX()) {
                value = rs.getString(columnIndex);
                boolean trim = false;
                if (property.getTrim() != null && !property.getTrim().booleanValue()) {
                    trim = false;
                } else if (property.getTrim() != null && property.getTrim().booleanValue()) {
                    trim = true;
                } else if (property.getTrim() == null && DBAccess.findAutotrim(contextName)) {
                    trim = true;
                }
                if (value != null && trim) {
                    value = ((String)value).trim();
                }
            } else if (propType == String.class && property.getString2bytes64()) {
                value = rs.getBytes(columnIndex);
                if (value != null) {
                    value = Base64.getEncoder().encodeToString((byte[])value);
                }
            } else if (propType == String.class && property.getString2bytesHEX()) {
                value = rs.getBytes(columnIndex);
                if (value != null) {
                    value = ValueManager.encodeHexString((byte[])((byte[])value));
                }
            } else if (propType == Character.class || propType == Character.TYPE) {
                String s = rs.getString(columnIndex);
                if (s != null && s.length() > 0) {
                    value = Character.valueOf(s.charAt(0));
                }
            } else if (propType == Integer.TYPE || propType == Integer.class) {
                value = rs.getInt(columnIndex);
            } else if (propType == Short.TYPE || propType == Short.class) {
                value = rs.getShort(columnIndex);
            } else if (propType == Byte.TYPE || propType == Byte.class) {
                value = rs.getByte(columnIndex);
            } else if (propType == Long.TYPE || propType == Long.class) {
                value = rs.getLong(columnIndex);
            } else if (propType == Float.TYPE || propType == Float.class) {
                value = Float.valueOf(rs.getFloat(columnIndex));
            } else if (propType == Double.TYPE || propType == Double.class) {
                value = rs.getDouble(columnIndex);
            } else if (propType == BigDecimal.class) {
                value = rs.getBigDecimal(columnIndex);
            } else if (propType == BigInteger.class) {
                long l = rs.getLong(columnIndex);
                value = BigInteger.valueOf(l);
            } else if (propType == LocalDateTime.class) {
                value = rs.getTimestamp(columnIndex).toLocalDateTime();
            } else if (propType == LocalDate.class) {
                if (property.getLocalDate2longYYYYMMDD()) {
                    long l = rs.getLong(columnIndex);
                    value = DOFWMapper.convertYYYYMMDDToLocalDate(l);
                } else if (property.getLocalDate2longYYMMDD()) {
                    long l = rs.getLong(columnIndex);
                    value = DOFWMapper.convertYYMMDDToLocalDate(property, rs, l);
                } else {
                    value = rs.getDate(columnIndex).toLocalDate();
                }
            } else if (propType == LocalTime.class) {
                value = rs.getTime(columnIndex).toLocalTime();
            } else if (propType == Date.class) {
                value = rs.getDate(columnIndex);
            } else if (propType == Time.class) {
                value = rs.getTime(columnIndex);
            } else if (propType == Timestamp.class) {
                value = rs.getTimestamp(columnIndex);
            } else if (java.util.Date.class.isAssignableFrom(propType)) {
                if (property.getDate2long()) {
                    long l = rs.getLong(columnIndex);
                    value = DOFWMapper.createDate(propType, l);
                } else if (property.getDate2longYYYYMMDD()) {
                    long l = rs.getLong(columnIndex);
                    LocalDate ld = DOFWMapper.convertYYYYMMDDToLocalDate(l);
                    value = DOFWMapper.convertLocalDateToDate(propType, ld);
                } else if (property.getDate2longYYMMDD()) {
                    long l = rs.getLong(columnIndex);
                    LocalDate ld = DOFWMapper.convertYYMMDDToLocalDate(property, rs, l);
                    value = DOFWMapper.convertLocalDateToDate(propType, ld);
                } else {
                    long l = rs.getTimestamp(columnIndex).getTime();
                    value = new java.util.Date(l);
                }
            } else if (propType == Boolean.class || propType == Boolean.TYPE) {
                if (property.getBoolean2int()) {
                    boolean boolValue = false;
                    if (1 == rs.getInt(columnIndex)) {
                        boolValue = true;
                    }
                    value = boolValue;
                } else if (property.getBoolean2StringX()) {
                    boolean boolValue = false;
                    if ("X".equals(rs.getString(columnIndex))) {
                        boolValue = true;
                    }
                    value = boolValue;
                } else if (property.getBoolean2StringJN()) {
                    if ("J".equals(rs.getString(columnIndex))) {
                        value = true;
                    } else if ("N".equals(rs.getString(columnIndex))) {
                        value = false;
                    } else if (property.getBoolean2StringDefault() == ENUMBooleanDefault.TRUE) {
                        value = true;
                    } else if (property.getBoolean2StringDefault() == ENUMBooleanDefault.FALSE) {
                        value = false;
                    } else if (property.getBoolean2StringDefault() == ENUMBooleanDefault.NULL) {
                        value = null;
                    }
                } else if (property.getBoolean2StringYN()) {
                    if ("Y".equals(rs.getString(columnIndex))) {
                        value = true;
                    } else if ("N".equals(rs.getString(columnIndex))) {
                        value = false;
                    } else if (property.getBoolean2StringDefault() == ENUMBooleanDefault.TRUE) {
                        value = true;
                    } else if (property.getBoolean2StringDefault() == ENUMBooleanDefault.FALSE) {
                        value = false;
                    } else if (property.getBoolean2StringDefault() == ENUMBooleanDefault.NULL) {
                        value = null;
                    }
                } else {
                    value = rs.getBoolean(columnIndex);
                }
            } else if (propType == UUID.class) {
                String v = rs.getString(columnIndex);
                if (value instanceof String) {
                    value = UUID.fromString((String)value);
                } else if (!(value instanceof UUID)) {
                    throw new Exception("UUID could not be interpreted, value class is: " + value.getClass().getName());
                }
            } else if (propType.isArray() && propType.getComponentType() == Byte.TYPE) {
                value = rs.getBytes(columnIndex);
            } else if (propType.isEnum()) {
                value = DOFWMapper.convertStringIntoEnum(rs.getString(columnIndex), propType);
            } else {
                try {
                    value = DOFWMapper.readAndMapDBValueViaSimpleDataTypeExtension(value, property, rs, columnIndex, propType);
                }
                catch (Exception exc) {
                    throw new Error("The data type that is passed is not handled within the persistence mapping: " + propType.getName(), exc);
                }
            }
            return value;
        }
        catch (Throwable t) {
            throw new Error("Error during mapping of " + property.getGetter().getName(), t);
        }
    }

    private static Object readAndMapDBValueViaSimpleDataTypeExtension(Object value, DOFWProperty property, ResultSet rs, int columnIndex, Class propType) throws Exception {
        ISimpleDataTypeExtension extension = ValueManager.getSimpleDataTypExtensionForClass((Class)propType);
        if (extension == null) {
            throw new Exception("Extension could not be found for property type: " + propType.getClass());
        }
        if (extension != null && extension instanceof ISimpleDataTypeExtensionDOFW) {
            Object result = ((ISimpleDataTypeExtensionDOFW)extension).convertResultSetValueIntoSimpleDataTypeValue(value, property, rs, columnIndex, propType);
            return result;
        }
        throw new Exception("Extension is not implementing interface ISimpleDataTypeExtensionDOFW: " + extension.getClass().getName());
    }

    private static Object createDate(Class dateClass, long l) {
        if (dateClass == null || dateClass == java.util.Date.class) {
            return new java.util.Date(l);
        }
        try {
            java.util.Date result = (java.util.Date)dateClass.newInstance();
            result.setTime(l);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Could not create Date-instance for class: " + dateClass.getName(), t);
        }
    }

    private static java.util.Date convertLocalDateToDate(Class dateClass, LocalDate ld) {
        if (ld == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(ld.getYear(), ld.getMonthValue() - 1, ld.getDayOfMonth());
        java.util.Date dateResult = cal.getTime();
        if (dateClass == null || dateClass == java.util.Date.class) {
            return dateResult;
        }
        try {
            java.util.Date ownClassResult = (java.util.Date)dateClass.newInstance();
            ownClassResult.setTime(dateResult.getTime());
            return ownClassResult;
        }
        catch (Throwable t) {
            throw new Error("Could not create Date-instance for class: " + dateClass.getName(), t);
        }
    }

    private static LocalDate convertDateToLocalDate(java.util.Date d) {
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return LocalDate.of(cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    public static LocalDate JUNIT_convertYYYYMMDDToLocalDate(long l) {
        return DOFWMapper.convertYYYYMMDDToLocalDate(l);
    }

    private static LocalDate convertYYMMDDToLocalDate(DOFWProperty property, ResultSet rs, long l) {
        if (property.getYYMMDDCenturyReference() == null) {
            if (l == 0L) {
                return null;
            }
            if (l == 99999999L) {
                l = 20491231L;
            }
            return DOFWMapper.convertYYMMDDToLocalDate(l);
        }
        if (l == 0L) {
            return null;
        }
        long century = -1L;
        try {
            century = rs.getLong(property.getYYMMDDCenturyReference());
            if (l == 999999L) {
                century = 20L;
                l = 491231L;
            }
            if (century >= 1L && century <= 9L || century >= 100L) {
                throw new Error("invalid century value: " + century);
            }
            if (century <= 0L) {
                century = l >= 800000L ? 19L : 20L;
            }
            l = century * 1000000L + l;
            return DOFWMapper.convertYYYYMMDDToLocalDate(l);
        }
        catch (Throwable t) {
            throw new Error("Could not read century reference: " + property.getName() + ", " + property.getYYMMDDCenturyReference() + ", " + l + ", " + century + ", returning null to application", t);
        }
    }

    public static LocalDate junit_convertYYYYMMDDToLocalDate(long l) {
        return DOFWMapper.convertYYYYMMDDToLocalDate(l);
    }

    private static LocalDate convertYYYYMMDDToLocalDate(long l) {
        if (l == 0L) {
            return null;
        }
        try {
            int day = (int)(l % 100L);
            int month = (int)(l % 10000L / 100L);
            int year = (int)(l / 10000L);
            LocalDate value = LocalDate.of(year, month, day);
            return value;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Could not convert DB long value into LocalDate: " + l + ", returning null to application", t);
            return null;
        }
    }

    private static LocalDate convertYYMMDDToLocalDate(long l) {
        try {
            if (l == 0L) {
                return null;
            }
            int day = (int)(l % 100L);
            int month = (int)(l % 10000L / 100L);
            int year = (int)(l / 10000L);
            year = year >= 80 ? 1900 + year : 2000 + year;
            LocalDate value = LocalDate.of(year, month, day);
            return value;
        }
        catch (Throwable t) {
            throw new Error("Could not convert long into LocalDate: " + l, t);
        }
    }

    public static void mapPropertyValue2PreparedStatement(String contextName, Object value, PreparedStatement ps, DOFWProperty property, int counter) {
        DOFWMapper.mapPropertyValue2PreparedStatement(contextName, value, ps, property, null, counter);
    }

    public static void mapPropertyValue2PreparedStatement(String contextName, Object value, PreparedStatement ps, DOFWProperty property, ENUMMappingInfo[] mappingInfos, int counter) {
        try {
            if (value == null && property.getDbNullValue() != null) {
                value = property.getDbNullValue();
            }
            if (value == null || value == "CCEE_NULL") {
                if (property.getDate2longYYMMDD() || property.getDate2longYYYYMMDD() || property.getLocalDate2longYYMMDD() || property.getLocalDate2longYYYYMMDD()) {
                    ps.setLong(counter, 0L);
                    return;
                }
                boolean success = DOFWMapper.mapPropertyValue2PreparedStatementViaSimpleDataTypeExtension(value, property, ps, counter);
                if (success) {
                    return;
                }
                ps.setObject(counter, null);
                return;
            }
            Class<?> propType = property.getType();
            if (propType == String.class && !property.getString2bytes64() && !property.getString2bytesHEX()) {
                ps.setString(counter, (String)value);
            } else if (propType == String.class && property.getString2bytes64()) {
                byte[] bytes = Base64.getDecoder().decode((String)value);
                ps.setBytes(counter, bytes);
            } else if (propType == String.class && property.getString2bytesHEX()) {
                byte[] bytes = ValueManager.decodeHexString((String)((String)value));
                ps.setBytes(counter, bytes);
            } else if (propType == Character.class || propType == Character.TYPE) {
                ps.setString(counter, "" + value);
            } else if (propType == Integer.TYPE || propType == Integer.class) {
                if (value instanceof Integer) {
                    ps.setInt(counter, (Integer)value);
                } else {
                    ps.setString(counter, ValueManager.convertObject2ValueString((Object)value));
                }
            } else if (propType == Short.TYPE || propType == Short.class) {
                if (value instanceof Short) {
                    ps.setShort(counter, (Short)value);
                } else {
                    ps.setString(counter, ValueManager.convertObject2ValueString((Object)value));
                }
            } else if (propType == Byte.TYPE || propType == Byte.class) {
                if (value instanceof Byte) {
                    ps.setByte(counter, (Byte)value);
                } else {
                    ps.setString(counter, ValueManager.convertObject2ValueString((Object)value));
                }
            } else if (propType == Long.TYPE || propType == Long.class) {
                if (value instanceof Long) {
                    ps.setLong(counter, (Long)value);
                } else {
                    ps.setString(counter, ValueManager.convertObject2ValueString((Object)value));
                }
            } else if (propType == Float.TYPE || propType == Float.class) {
                if (value instanceof Float) {
                    ps.setFloat(counter, ((Float)value).floatValue());
                } else {
                    ps.setString(counter, ValueManager.convertObject2ValueString((Object)value));
                }
            } else if (propType == Double.TYPE || propType == Double.class) {
                if (value instanceof Double) {
                    ps.setDouble(counter, (Double)value);
                } else {
                    ps.setString(counter, ValueManager.convertObject2ValueString((Object)value));
                }
            } else if (propType == BigDecimal.class) {
                if (value instanceof BigDecimal) {
                    ps.setBigDecimal(counter, (BigDecimal)value);
                } else {
                    ps.setString(counter, ValueManager.convertObject2ValueString((Object)value));
                }
            } else if (propType == BigInteger.class) {
                if (value instanceof BigInteger) {
                    ps.setLong(counter, ((BigInteger)value).longValue());
                } else {
                    ps.setString(counter, ValueManager.convertObject2ValueString((Object)value));
                }
            } else if (propType == Date.class) {
                ps.setDate(counter, (Date)value);
            } else if (propType == Time.class) {
                ps.setTime(counter, (Time)value);
            } else if (propType == Timestamp.class) {
                ps.setTimestamp(counter, (Timestamp)value);
            } else if (java.util.Date.class.isAssignableFrom(propType)) {
                java.util.Date d = (java.util.Date)value;
                if (property.getDate2long()) {
                    ps.setLong(counter, d.getTime());
                } else if (property.getDate2longYYYYMMDD()) {
                    LocalDate ld = DOFWMapper.convertDateToLocalDate(d);
                    long lo = ld.getDayOfMonth() + ld.getMonthValue() * 100 + ld.getYear() * 10000;
                    ps.setLong(counter, lo);
                } else if (property.getDate2longYYMMDD()) {
                    LocalDate ld = DOFWMapper.convertDateToLocalDate(d);
                    if (!DOFWMapper.checkIfMappingInfosContains(mappingInfos, ENUMMappingInfo.IS_YYMMDDCENTURYREFRENCE)) {
                        int year = ld.getYear();
                        long lo = ld.getDayOfMonth() + ld.getMonthValue() * 100 + (year %= 100) * 10000;
                        ps.setLong(counter, lo);
                    } else {
                        int year = ld.getYear();
                        ps.setInt(counter, year /= 100);
                    }
                } else {
                    ps.setTimestamp(counter, new Timestamp(d.getTime()));
                }
            } else if (propType == LocalDateTime.class) {
                LocalDateTime l = (LocalDateTime)value;
                ps.setTimestamp(counter, Timestamp.valueOf(l));
            } else if (propType == LocalDate.class) {
                if (property.getLocalDate2longYYYYMMDD()) {
                    LocalDate l = (LocalDate)value;
                    long lo = l.getDayOfMonth() + l.getMonthValue() * 100 + l.getYear() * 10000;
                    ps.setLong(counter, lo);
                } else if (property.getLocalDate2longYYMMDD()) {
                    LocalDate l = (LocalDate)value;
                    if (!DOFWMapper.checkIfMappingInfosContains(mappingInfos, ENUMMappingInfo.IS_YYMMDDCENTURYREFRENCE)) {
                        int year = l.getYear();
                        long lo = l.getDayOfMonth() + l.getMonthValue() * 100 + (year %= 100) * 10000;
                        ps.setLong(counter, lo);
                    } else {
                        int year = l.getYear();
                        ps.setInt(counter, year /= 100);
                    }
                } else {
                    LocalDate l = (LocalDate)value;
                    ps.setDate(counter, Date.valueOf(l));
                }
            } else if (propType == LocalTime.class) {
                LocalTime l = (LocalTime)value;
                ps.setTime(counter, Time.valueOf(l));
            } else if (propType == Boolean.class || propType == Boolean.TYPE) {
                if (property.getBoolean2int()) {
                    int intValue = 0;
                    if ("true".equals(value + "")) {
                        intValue = 1;
                    }
                    ps.setInt(counter, intValue);
                } else if (property.getBoolean2StringX()) {
                    String stringValue = " ";
                    if ("true".equals(value + "")) {
                        stringValue = "X";
                    }
                    ps.setString(counter, stringValue);
                } else if (property.getBoolean2StringJN()) {
                    String stringValue = "N";
                    if ("true".equals(value + "")) {
                        stringValue = "J";
                    }
                    ps.setString(counter, stringValue);
                } else if (property.getBoolean2StringYN()) {
                    String stringValue = "N";
                    if ("true".equals(value + "")) {
                        stringValue = "Y";
                    }
                    ps.setString(counter, stringValue);
                } else {
                    ps.setBoolean(counter, (Boolean)value);
                }
            } else if (propType == UUID.class) {
                if (DOFWDialect.checkIfUUIDIsRepresentedAsString(contextName) || property.getUuid2String()) {
                    ps.setString(counter, ((UUID)value).toString());
                } else {
                    ps.setObject(counter, value);
                }
            } else if (propType.isArray() && propType.getComponentType() == Byte.TYPE) {
                ps.setBytes(counter, (byte[])value);
            } else if (propType.isEnum()) {
                String enumStringValue = ((Enum)value).name();
                ps.setString(counter, enumStringValue);
            } else {
                boolean success = DOFWMapper.mapPropertyValue2PreparedStatementViaSimpleDataTypeExtension(value, property, ps, counter);
                if (!success) {
                    throw new Error("The data type that is passed is not handled within the persistence mapping: " + propType.getName());
                }
            }
        }
        catch (Throwable t) {
            throw new Error("Error during mapping to prepared statement " + property.getGetter().getName(), t);
        }
    }

    private static boolean mapPropertyValue2PreparedStatementViaSimpleDataTypeExtension(Object value, DOFWProperty property, PreparedStatement ps, int counter) throws SQLException {
        ISimpleDataTypeExtension extension = ValueManager.getSimpleDataTypExtensionForClass(property.getType());
        if (extension != null && extension instanceof ISimpleDataTypeExtensionDOFW) {
            ((ISimpleDataTypeExtensionDOFW)extension).passSimpleDataTypeValueIntoPreparedStatement(value, property, ps, counter);
            return true;
        }
        return false;
    }

    private static boolean checkIfMappingInfosContains(ENUMMappingInfo[] infos, ENUMMappingInfo containedInfo) {
        if (infos == null) {
            return false;
        }
        for (ENUMMappingInfo info : infos) {
            if (info != containedInfo) continue;
            return true;
        }
        return false;
    }

    private static Object convertStringIntoEnum(String attrValue, Class enumClass) {
        try {
            T[] os;
            if (attrValue == null) {
                return null;
            }
            for (Object o : os = enumClass.getEnumConstants()) {
                if (!((Enum)o).name().equals(attrValue)) continue;
                return o;
            }
            for (Object o : os) {
                if (!o.toString().equals(attrValue)) continue;
                return o;
            }
            throw new Exception("Enum constant does not exsit for value: " + attrValue);
        }
        catch (Throwable t) {
            AppLog.L.log(LL_INF, "Error when converting value string to Enumeration " + attrValue + "/" + enumClass.getName());
            throw new Error("Could not convert enum value: " + attrValue + " into enum of type: " + enumClass.getName(), t);
        }
    }

    public static String getNullValueForSQLStatement(DOFWProperty property) {
        if (property.getDate2longYYMMDD() || property.getDate2longYYYYMMDD() || property.getLocalDate2longYYMMDD() || property.getLocalDate2longYYYYMMDD()) {
            return "0";
        }
        return "CCEE_NULL";
    }
}

