/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.dofw.util;

import java.util.ArrayList;
import java.util.List;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.db.dofw.DOFWDialect;
import org.eclnt.ccee.db.dofw.DOFWEntity;
import org.eclnt.ccee.db.dofw.DOFWProperty;
import org.eclnt.ccee.db.dofw.DOFWRepository;
import org.eclnt.ccee.db.util.QueryUtils;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.util.useraccess.LanguageAccessMgr;
import org.eclnt.jsfserver.util.useraccess.TenantAccessMgr;
import org.eclnt.jsfserver.util.useraccess.UserAccessMgr;
import org.eclnt.util.valuemgmt.PojoManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class DOFWUtils
implements ICCEEConstants {
    public static SplitUpColVals splitUpQueryColVals(Object ... colVals) {
        if (colVals == null) {
            return new SplitUpColVals(null, null);
        }
        int orderByIndex = -1;
        for (int i = 0; i < colVals.length; ++i) {
            if (colVals[i] != "order_by") continue;
            orderByIndex = i;
            break;
        }
        if (orderByIndex < 0) {
            return new SplitUpColVals(colVals, null);
        }
        Object[] p1 = null;
        if (orderByIndex > 0) {
            p1 = new Object[orderByIndex];
            for (int i = 0; i < orderByIndex; ++i) {
                p1[i] = colVals[i];
            }
        }
        Object[] p2 = null;
        if (orderByIndex < colVals.length - 1) {
            p2 = new Object[colVals.length - 1 - orderByIndex];
            for (int i = orderByIndex + 1; i < colVals.length; ++i) {
                p2[i - orderByIndex - 1] = colVals[i];
            }
        }
        return new SplitUpColVals(p1, p2);
    }

    public static String quc(String contextName, String columnName) {
        String sur = DOFWDialect.getColumnNameSurrounder(contextName);
        if (sur == null) {
            return columnName;
        }
        return sur + columnName + sur;
    }

    public static String qut(String contextName, String tableName) {
        tableName = DOFWUtils.executeSpecialValuesReplacementsOnTableName(tableName);
        String sur = DOFWDialect.getTableNameSurrounder(contextName);
        if (sur == null) {
            return tableName;
        }
        int dotIndex = tableName.indexOf(".");
        if (dotIndex < 0) {
            return sur + tableName + sur;
        }
        String schemaPart = tableName.substring(0, dotIndex);
        String tablePart = tableName.substring(dotIndex + 1);
        return sur + schemaPart + sur + "." + sur + tablePart + sur;
    }

    private static String executeSpecialValuesReplacementsOnTableName(String tableName) {
        if (tableName == null) {
            return null;
        }
        if (!tableName.contains("${")) {
            return tableName;
        }
        if (tableName.indexOf("${ccee.tenant}") >= 0) {
            String tenant = TenantAccessMgr.getCurrentTenant();
            tableName = tableName.replace("${ccee.tenant}", tenant);
        }
        if (tableName.indexOf("${ccee.user}") >= 0) {
            String user = UserAccessMgr.getCurrentUser();
            tableName = tableName.replace("${ccee.user}", user);
        }
        if (tableName.indexOf("${ccee.language}") >= 0) {
            String language = LanguageAccessMgr.getCurrentLanguage();
            tableName = tableName.replace("${ccee.language}", language);
        }
        return tableName;
    }

    public static ReplaceResult replaceVariables(String contextName, Class clazz, String s) {
        int index2;
        int index1;
        ReplaceResult result = new ReplaceResult();
        if (s == null) {
            return result;
        }
        if (s.trim().length() == 0) {
            return result;
        }
        DOFWEntity entity = DOFWRepository.getEntity(clazz, true);
        while ((index1 = s.indexOf("?v(")) >= 0 && (index2 = s.indexOf(")", index1 + 3)) >= 0) {
            String propertyName = s.substring(index1 + 3, index2);
            if (propertyName.length() == 0) {
                result.i_properties.add(null);
            } else {
                DOFWProperty p = DOFWRepository.getProperty(clazz, propertyName, true);
                result.i_properties.add(p);
            }
            s = s.substring(0, index1) + "?" + s.substring(index2 + 1);
        }
        result.i_queryString = s;
        return result;
    }

    public static List<DOFWProperty> findPropertiesInColumns(Class clazz, String[] colSelections) {
        ArrayList<DOFWProperty> result = new ArrayList<DOFWProperty>();
        if (colSelections == null) {
            return result;
        }
        for (String colSelection : colSelections) {
            int index1 = colSelection.indexOf("?p(");
            int index2 = colSelection.indexOf(")");
            if (index1 == 0 && index2 == colSelection.length() - 1) {
                String propertyName = colSelection.substring(index1 + 3, index2);
                DOFWProperty p = DOFWRepository.getProperty(clazz, propertyName, true);
                result.add(p);
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public static String replacePropertyNames(String contextName, Class clazz, String s) {
        int index2;
        int index1;
        if (s == null) {
            return s;
        }
        if (s.trim().length() == 0) {
            return s;
        }
        DOFWEntity entity = DOFWRepository.getEntity(clazz, true);
        while ((index1 = s.indexOf("?p(")) >= 0 && (index2 = s.indexOf(")", index1 + 3)) >= 0) {
            String propertyName = s.substring(index1 + 3, index2);
            DOFWProperty p = DOFWRepository.getProperty(clazz, propertyName, true);
            s = s.substring(0, index1) + DOFWUtils.quc(contextName, p.getColumn()) + s.substring(index2 + 1);
        }
        return s;
    }

    public static String parseICCEEConstant(String s) {
        if (s == null) {
            throw new Error("No value passed!");
        }
        if ("AND".equals(s)) {
            return "AND";
        }
        if ("OR".equals(s)) {
            return "OR";
        }
        if ("IS".equals(s)) {
            return "=";
        }
        if ("=".equals(s)) {
            return "=";
        }
        if ("ISNOT".equals(s)) {
            return "<>";
        }
        if ("<>".equals(s)) {
            return "<>";
        }
        if ("LIKE".equals(s)) {
            return "LIKE";
        }
        if ("GREATER".equals(s)) {
            return ">";
        }
        if (">".equals(s)) {
            return ">";
        }
        if ("GREATEREQUAL".equals(s)) {
            return ">=";
        }
        if (">=".equals(s)) {
            return ">=";
        }
        if ("LOWER".equals(s)) {
            return "<";
        }
        if ("<".equals(s)) {
            return "<";
        }
        if ("LOWEREQUAL".equals(s)) {
            return "<=";
        }
        if ("<=".equals(s)) {
            return "<=";
        }
        if ("IN".equals(s)) {
            return "IN";
        }
        if ("BETWEEN".equals(s)) {
            return "BETWEEN";
        }
        if ("BRO".equals(s)) {
            return "(";
        }
        if ("(".equals(s)) {
            return "(";
        }
        if ("BRC".equals(s)) {
            return ")";
        }
        if (")".equals(s)) {
            return ")";
        }
        if ("ASC".equals(s)) {
            return "ASC";
        }
        if ("DESC".equals(s)) {
            return "DESC";
        }
        if ("COUNT".equals(s)) {
            return "COUNT";
        }
        if ("AVG".equals(s)) {
            return "AVG";
        }
        if ("SUM".equals(s)) {
            return "SUM";
        }
        if ("MIN".equals(s)) {
            return "MIN";
        }
        if ("MAX".equals(s)) {
            return "MAX";
        }
        throw new Error("Could not parse ICCEConstant: " + s);
    }

    public static boolean checkIfPropertyHasCenturyColumn(DOFWProperty property) {
        return (property.getDate2longYYMMDD() || property.getLocalDate2longYYMMDD()) && property.getYYMMDDCenturyReference() != null;
    }

    public static Object[] transferSortStringIntoDOFWQueryObjects(String query) {
        return QueryUtils.transferSortStringIntoQueryObjects(query);
    }

    public static Object[] transferSortStringIntoDOFWQueryObjects(String[] query) {
        return QueryUtils.transferSortStringIntoQueryObjects(query);
    }

    public static Object[] transferQueryStringIntoDOFWQueryObjects(String className, String query) {
        return QueryUtils.transferQueryStringIntoQueryObjects(className, query, new QueryUtils.IValueClassProvider(){

            @Override
            public Class findTypeForProperty(String structureName, String propertyName) {
                try {
                    Class<?> dddClass = Class.forName(structureName, true, HotDeployManager.currentClassLoader());
                    Class<?> propertyClass = DOFWRepository.getProperty(dddClass, propertyName).getType();
                    return propertyClass;
                }
                catch (Throwable t) {
                    throw new Error("Could not find class for property: " + structureName + ", " + propertyName, t);
                }
            }
        });
    }

    public static Object[] transferQueryStringIntoDOFWQueryObjects(String className, String[] query) {
        return QueryUtils.transferQueryStringIntoQueryObjects(className, query, new QueryUtils.IValueClassProvider(){

            @Override
            public Class findTypeForProperty(String structureName, String propertyName) {
                try {
                    Class<?> dddClass = Class.forName(structureName, true, HotDeployManager.currentClassLoader());
                    Class<?> propertyClass = DOFWRepository.getProperty(dddClass, propertyName).getType();
                    return propertyClass;
                }
                catch (Throwable t) {
                    throw new Error("Could not find class for property: " + structureName + ", " + propertyName, t);
                }
            }
        });
    }

    public static Object[] transferKeyPathIntoQuery(String keyPath, Class beanClass) {
        if (keyPath == null) {
            throw new Error("keyPath must not be null");
        }
        if (beanClass == null) {
            throw new Error("beanClass must not be null");
        }
        try {
            String[] values = ValueManager.tokenize((String)keyPath, (String)"|");
            List<DOFWProperty> keyProps = DOFWRepository.getKeyPropertiesSorted(beanClass);
            ArrayList<String> stringQuery = new ArrayList<String>();
            int counter = 0;
            for (DOFWProperty keyProp : keyProps) {
                stringQuery.add(keyProp.getName());
                stringQuery.add("IS");
                stringQuery.add(values[counter]);
                ++counter;
            }
            String[] stringQueryArray = stringQuery.toArray(new String[stringQuery.size()]);
            return DOFWUtils.transferQueryStringIntoDOFWQueryObjects(beanClass.getName(), stringQueryArray);
        }
        catch (Throwable t) {
            throw new Error("Could not transfer key path into query: " + beanClass.getName() + ", " + keyPath, t);
        }
    }

    public static boolean checkIfKeyOfObjectsIsSame(Object bean1, Object bean2) {
        String key1 = DOFWUtils.resolveKeyPathForBean(bean1);
        String key2 = DOFWUtils.resolveKeyPathForBean(bean2);
        return ValueManager.checkIfStringsAreEqual((String)key1, (String)key2);
    }

    public static String resolveKeyPathForBean(Object bean) {
        return DOFWUtils.resolveKeyPathForBean(bean, "|");
    }

    public static String resolveKeyPathForBean(Object bean, String delimiter) {
        if (bean == null) {
            return null;
        }
        if (delimiter == null) {
            throw new Error("Delimiter passed as null");
        }
        try {
            List<DOFWProperty> keyProps = DOFWRepository.getKeyPropertiesSorted(bean.getClass());
            StringBuffer sb = new StringBuffer();
            int counter = 0;
            for (DOFWProperty prop : keyProps) {
                Object v = PojoManager.getPropertyValue((Object)bean, (String)prop.getName());
                String vs = ValueManager.convertObject2ValueString((Object)v);
                if (vs == null) {
                    vs = "@@null@@";
                }
                if (counter > 0) {
                    sb.append(delimiter);
                }
                sb.append(vs);
                ++counter;
            }
            return sb.toString();
        }
        catch (Throwable t) {
            throw new Error("Could not resolve key path for bean: " + bean.getClass().getName(), t);
        }
    }

    public static Object[] mergeOrderBys(Object[] sort1, Object[] sort2) {
        if (sort1 == null || sort1.length == 0) {
            return sort2;
        }
        if (sort2 == null || sort2.length == 0) {
            return sort1;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object s1 : sort1) {
            result.add(s1);
        }
        for (int i = 0; i < sort2.length; ++i) {
            Object s2 = sort2[i];
            if (s2 == "ASC" || s2 == "DESC" || result.contains(s2)) continue;
            result.add(s2);
            try {
                Object s2p1 = sort2[i + 1];
                if (s2p1 != "ASC" && s2p1 != "DESC") continue;
                result.add(s2p1);
                ++i;
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result.toArray(new Object[result.size()]);
    }

    public static class SplitUpColVals {
        Object[] i_colVals;
        Object[] i_orderBy;

        public SplitUpColVals(Object[] colVals, Object[] orderBy) {
            this.i_colVals = colVals;
            this.i_orderBy = orderBy;
        }

        public Object[] getColVals() {
            return this.i_colVals;
        }

        public Object[] getOrderBy() {
            return this.i_orderBy;
        }
    }

    public static class ReplaceResult {
        String i_queryString;
        List<DOFWProperty> i_properties = new ArrayList<DOFWProperty>();

        public String getQueryString() {
            return this.i_queryString;
        }

        public List<DOFWProperty> getProperties() {
            return this.i_properties;
        }
    }
}

