/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.HashMap;
import org.eclnt.ccee.bridges.ClassLoaderBridge;

public class CloneUtil {
    public static <CLASS extends Serializable> CLASS createClone(CLASS o) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(o);
            oos.flush();
            oos.close();
            bos.close();
            byte[] bytes = bos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            MyObjectInputStream mois = new MyObjectInputStream(bais, o.getClass().getClassLoader());
            Serializable result = (Serializable)mois.readObject();
            mois.close();
            return (CLASS)result;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static class MyObjectInputStream
    extends ObjectInputStream {
        private static final HashMap<String, Class<?>> primClasses = new HashMap(8, 1.0f);
        ClassLoader i_classLoader;

        public MyObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.i_classLoader = classLoader;
        }

        public MyObjectInputStream(InputStream in) throws IOException {
            this(in, ClassLoaderBridge.findCurrentClassLoader());
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            try {
                return Class.forName(name, false, this.i_classLoader);
            }
            catch (ClassNotFoundException ex) {
                Class<?> cl = primClasses.get(name);
                if (cl != null) {
                    return cl;
                }
                throw ex;
            }
        }

        static {
            primClasses.put("boolean", Boolean.TYPE);
            primClasses.put("byte", Byte.TYPE);
            primClasses.put("char", Character.TYPE);
            primClasses.put("short", Short.TYPE);
            primClasses.put("int", Integer.TYPE);
            primClasses.put("long", Long.TYPE);
            primClasses.put("float", Float.TYPE);
            primClasses.put("double", Double.TYPE);
            primClasses.put("void", Void.TYPE);
        }
    }
}

