/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.weakcache;

import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclnt.ccee.weakcache.ICachedObjectCreator;

public class WeakCache {
    static WeakCache s_instance = new WeakCache();
    WeakHashMap<Object, Map<String, Object>> m_beanLevelCaches = new WeakHashMap();

    public static WeakCache instance() {
        return s_instance;
    }

    public static void intialize(WeakCache instance) {
        s_instance = instance;
    }

    public <OBJTYPE> OBJTYPE getCachedObject(Object beanReference, Class<OBJTYPE> clazz, ICachedObjectCreator<OBJTYPE> creator) {
        return this.getCachedObject(beanReference, this.class2Key(clazz), creator);
    }

    public <OBJTYPE> OBJTYPE getCachedObject(Object beanReference, String key, ICachedObjectCreator<OBJTYPE> creator) {
        Map<String, Object> beanLevelCache = this.readBeanLevelCache(beanReference, true);
        Object result = beanLevelCache.get(key);
        if (result == null) {
            result = creator.createNewInstance();
            beanLevelCache.put(key, result);
        }
        return (OBJTYPE)result;
    }

    public void clearCachedObject(Object beanReference, Class clazz) {
        Map<String, Object> beanLevelCache = this.readBeanLevelCache(beanReference, false);
        if (beanLevelCache != null) {
            beanLevelCache.remove(this.class2Key(clazz));
        }
    }

    public void clearCache(Object beanReference) {
        Map<String, Object> beanLevelCache = this.readBeanLevelCache(beanReference, false);
        if (beanLevelCache != null) {
            beanLevelCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> readBeanLevelCache(Object beanReference, boolean createIfNotExists) {
        Map<String, Object> beanLevelCache = this.m_beanLevelCaches.get(beanReference);
        if (beanLevelCache == null && createIfNotExists) {
            WeakHashMap<Object, Map<String, Object>> weakHashMap = this.m_beanLevelCaches;
            synchronized (weakHashMap) {
                beanLevelCache = this.m_beanLevelCaches.get(beanReference);
                if (beanLevelCache == null) {
                    beanLevelCache = new Hashtable<String, Object>();
                    this.m_beanLevelCaches.put(beanReference, beanLevelCache);
                }
            }
        }
        return beanLevelCache;
    }

    private String class2Key(Class clazz) {
        return "class:" + clazz.getName();
    }
}

