/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.xml;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclnt.util.valuemgmt.Base64;
import org.eclnt.util.valuemgmt.PojoManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class XMLPojoUtil {
    private static XMLPojoUtil s_instance = new XMLPojoUtil();

    public static XMLPojoUtil instance() {
        return s_instance;
    }

    public static void initialize(XMLPojoUtil instance) {
        s_instance = instance;
    }

    public String encodePojoSDTToXMLBegin(Object o, String oTagName) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(oTagName);
        Map oMap = PojoManager.transferPojoIntoMap((Object)o);
        ArrayList properties = new ArrayList(oMap.keySet());
        Collections.sort(properties);
        for (String property : properties) {
            Object propertyValue;
            String propertyString = this.convertPropertyIntoXMLString(property, propertyValue = oMap.get(property));
            if (propertyString == null) continue;
            sb.append(" ");
            sb.append(property);
            sb.append("=");
            sb.append("\"");
            sb.append(ValueManager.encodeIntoValidXMLValueString((String)propertyString));
            sb.append("\"");
        }
        sb.append(">");
        return sb.toString();
    }

    public String encodePojoSDTToXMLEnd(Object o, String oTagName) {
        StringBuffer sb = new StringBuffer();
        sb.append("</");
        sb.append(oTagName);
        sb.append(">");
        return sb.toString();
    }

    protected String convertPropertyIntoXMLString(String property, Object propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue instanceof byte[]) {
            return Base64.encode((byte[])((byte[])propertyValue));
        }
        if (propertyValue instanceof LocalDate) {
            return ((LocalDate)propertyValue).toString();
        }
        if (propertyValue instanceof LocalDateTime) {
            return ((LocalDateTime)propertyValue).toString();
        }
        if (propertyValue instanceof LocalTime) {
            return ((LocalTime)propertyValue).toString();
        }
        return ValueManager.convertObject2ValueString((Object)propertyValue);
    }
}

