/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.chatgpt.logic.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.ccee.json.jackson.JSONUtil;

public class OpenAIJson {
    static OpenAIJson s_instance = new OpenAIJson();

    public static OpenAIJson instance() {
        return s_instance;
    }

    public String parseCompletionResponseForMessageContent(String json) {
        Map<String, Object> m = JSONUtil.unmarshalMap(json);
        List choices = (List)m.get("choices");
        if (choices != null && choices.size() > 0) {
            Map choice = (Map)choices.get(0);
            Map message = (Map)choice.get("message");
            return (String)message.get("content");
        }
        return null;
    }

    public String createCompletion(List<String> messageTexts) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("model", "gpt-4o-mini");
        ArrayList messages = new ArrayList();
        m.put("messages", messages);
        for (String messageText : messageTexts) {
            HashMap<String, String> message = new HashMap<String, String>();
            message.put("role", "user");
            message.put("content", messageText);
            messages.add(message);
        }
        String result = JSONUtil.marshalMap(m);
        return result;
    }

    public String parseThreadsResponseForId(String json) {
        Map<String, Object> m = JSONUtil.unmarshalMap(json);
        return (String)m.get("id");
    }

    public String createThreadMessage(String role, String content) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("role", role);
        m.put("content", content);
        return JSONUtil.marshalMap(m);
    }

    public String parseThreadMessageResponseForId(String json) {
        Map<String, Object> m = JSONUtil.unmarshalMap(json);
        return (String)m.get("id");
    }

    public String createModifyMessage(String modification) {
        return null;
    }

    public String createRunMessage(String assistantId, boolean stream) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("assistant_id", assistantId);
        m.put("stream", stream);
        return JSONUtil.marshalMap(m);
    }

    public Map<String, Object> parseMessageResponse(String json) {
        Map<String, Object> m = JSONUtil.unmarshalMap(json);
        return m;
    }

    public String createAssistantRequest() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("model", "gpt-4o-mini");
        return JSONUtil.marshalMap(m);
    }

    public String parseAssistantResponseForId(String json) {
        Map<String, Object> m = JSONUtil.unmarshalMap(json);
        return (String)m.get("id");
    }

    public String createImageRequest(String text) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("prompt", text);
        m.put("size", "256x256");
        return JSONUtil.marshalMap(m);
    }

    public String parseImageResponseImageURL(String json) {
        try {
            Map<String, Object> m = JSONUtil.unmarshalMap(json);
            List data = (List)m.get("data");
            Map data1 = (Map)data.get(0);
            String url = (String)data1.get("url");
            return url;
        }
        catch (Throwable t) {
            throw new Error("No image was generated. Full response is: " + json);
        }
    }

    public String parseMessagesResponseForText(String response) {
        Map<String, Object> m = JSONUtil.unmarshalMap(response);
        List dataList = (List)m.get("data");
        Map data = (Map)dataList.get(0);
        List contentList = (List)data.get("content");
        Map content = (Map)contentList.get(0);
        Map text = (Map)content.get("text");
        String value = (String)text.get("value");
        return value;
    }

    public String parseFileUploadResponseForId(String json) {
        Map<String, Object> m = JSONUtil.unmarshalMap(json);
        return (String)m.get("id");
    }
}

