/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.dofw;

import org.eclnt.ccee.db.dofw.DOFWEntity;
import org.eclnt.ccee.db.dofw.DOFWProperty;
import org.eclnt.ccee.db.dofw.DOFWRepository;
import org.eclnt.ccee.db.dofw.util.DOFWUtils;

public class DOFWFunction {
    Class m_clazz;
    String m_functionStatement;
    String[] m_properties;
    DOFWFunctionValue[] m_values;
    String m_resultPropertyReference;

    public DOFWFunction(Class clazz, String functionStatement, String resultPropertyReference, String[] properties, DOFWFunctionValue[] values) {
        this.m_clazz = clazz;
        this.m_functionStatement = functionStatement;
        this.m_properties = properties;
        this.m_values = values;
        if (resultPropertyReference != "*") {
            this.m_resultPropertyReference = resultPropertyReference;
        }
    }

    public String buildSqlString(String contextName) {
        DOFWEntity entity = DOFWRepository.getEntity(this.m_clazz);
        if (entity == null) {
            throw new Error("Could not find entity for class: " + this.m_clazz);
        }
        String result = this.m_functionStatement;
        if (this.m_properties != null) {
            for (String property : this.m_properties) {
                DOFWProperty p = DOFWRepository.getProperty(this.m_clazz, property);
                if (p == null) {
                    throw new Error("Could not finde property " + this.m_clazz.getName() + ", " + property);
                }
                int index = result.indexOf("?p");
                if (index < 0) continue;
                result = result.substring(0, index) + DOFWUtils.quc(contextName, p.getColumn()) + result.substring(index + 2);
            }
        }
        if (this.m_values != null) {
            for (int i = 0; i < this.m_values.length; ++i) {
                int index = result.indexOf("?v");
                if (index < 0) continue;
                result = result.substring(0, index) + "?" + result.substring(index + 2);
            }
        }
        if (result.contains("?p")) {
            throw new Error("Still ?p contained in statement - but all should be replaced: " + result);
        }
        if (result.contains("?v")) {
            throw new Error("Still ?v contained in statement - but all should be replaced: " + result);
        }
        return result;
    }

    public DOFWFunctionValue[] getValues() {
        return this.m_values;
    }

    public String getResultPropertyReference() {
        return this.m_resultPropertyReference;
    }

    public static class DOFWFunctionValue {
        String i_propertyName;
        Object i_value;

        public DOFWFunctionValue(String propertyName, Object value) {
            this.i_propertyName = propertyName;
            this.i_value = value;
        }

        public String getPropertyName() {
            return this.i_propertyName;
        }

        public Object getValue() {
            return this.i_value;
        }
    }
}

