/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.file;

import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class ZipFileUtil {
    public static void unzipFileIntoDirectory(String zipFileName, String directoryName) {
        if (zipFileName == null) {
            throw new Error("No zipFileName passed");
        }
        if (directoryName == null) {
            throw new Error("No directory name passed");
        }
        boolean exist = FileManager.checkIfFileExists((String)zipFileName);
        if (!exist) {
            throw new Error("Zip file does not exist: " + zipFileName);
        }
        directoryName = ValueManager.encodeIntoValidFileName((String)directoryName, (boolean)true);
        FileManager.ensureDirectoryForFileExists((String)(directoryName + "test.test"));
        try {
            ZipFile file = new ZipFile(zipFileName);
            FileSystem fileSystem = FileSystems.getDefault();
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                int length;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    String fullDirectoryName = directoryName + entry.getName();
                    FileManager.ensureDirectoryExists((String)fullDirectoryName);
                    continue;
                }
                InputStream is = file.getInputStream(entry);
                BufferedInputStream bis = new BufferedInputStream(is);
                String uncompressedFileName = directoryName + entry.getName();
                Path uncompressedFilePath = fileSystem.getPath(uncompressedFileName, new String[0]);
                FileManager.ensureDirectoryForFileExists((String)uncompressedFileName);
                Files.createFile(uncompressedFilePath, new FileAttribute[0]);
                FileOutputStream fileOutput = new FileOutputStream(uncompressedFileName);
                byte[] byteBuffer = new byte[4096];
                while ((length = bis.read(byteBuffer)) > 0) {
                    fileOutput.write(byteBuffer, 0, length);
                }
                fileOutput.close();
            }
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

