/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.image;

import java.awt.Color;
import java.awt.image.BufferedImage;

public class ImageCompare {
    static final float COMPARISON_MINACCEPTANCEVALUE = 0.9f;

    public static float compareImages(BufferedImage image1, BufferedImage image2) {
        return ImageCompare.compareImages(image1, image2, Color.WHITE);
    }

    public static float compareImages(BufferedImage image1, BufferedImage image2, Color defaultColor) {
        if (image1.getWidth() != image2.getWidth()) {
            return 0.0f;
        }
        if (image1.getHeight() != image2.getHeight()) {
            return 0.0f;
        }
        Integer defaultColorRGB = null;
        if (defaultColor != null) {
            defaultColorRGB = defaultColor.getRGB();
        }
        float result = ImageCompare.comparePixels(image1, image2, defaultColorRGB);
        return result;
    }

    private static float comparePixels(BufferedImage image1, BufferedImage image2, Integer defaultColorRGB) {
        int numberOfDifferentPixels = 0;
        int numberOfCountedPixels = 0;
        for (int x = 0; x < image1.getWidth(); ++x) {
            for (int y = 0; y < image1.getHeight(); ++y) {
                int pixel2;
                int pixel1 = image1.getRGB(x, y);
                if (!ImageCompare.checkIfPixelsMatch(pixel1, pixel2 = image2.getRGB(x, y))) {
                    ++numberOfDifferentPixels;
                }
                if (defaultColorRGB != null && pixel1 == defaultColorRGB && pixel2 == defaultColorRGB) continue;
                ++numberOfCountedPixels;
            }
        }
        return 1.0f - (float)numberOfDifferentPixels / (float)numberOfCountedPixels;
    }

    private static boolean checkIfPixelsMatch(int pixel1, int pixel2) {
        float b;
        float g;
        Color c1 = new Color(pixel1);
        Color c2 = new Color(pixel2);
        float r = ImageCompare.compareColors(c1.getRed(), c2.getRed());
        float total = (r + (g = ImageCompare.compareColors(c1.getGreen(), c2.getGreen())) + (b = ImageCompare.compareColors(c1.getBlue(), c2.getBlue()))) / 3.0f;
        return total > 0.9f;
    }

    private static float compareColors(int val1, int val2) {
        int lower = Math.min(val1, val2);
        int higher = Math.max(val1, val2);
        int diff = higher - lower;
        if (diff == 0) {
            return 1.0f;
        }
        return (float)lower / (float)higher;
    }
}

