/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.image;

import org.eclnt.ccee.image.ImageShrinker;
import org.eclnt.ccee.pdf.PDF2ImageConverter;
import org.eclnt.util.file.FileManager;

public class ThumbImageCreator {
    public static byte[] createThumbImage(String fileName, int width, int height) {
        return ThumbImageCreator.createThumbImage(fileName, null, width, height);
    }

    public static byte[] createThumbImage(String fileName, String extension, int width, int height) {
        try {
            if (extension == null) {
                int lastDot = fileName.lastIndexOf(".");
                if (lastDot < 0) {
                    return null;
                }
                extension = fileName.substring(lastDot + 1);
            }
            if ("pdf".equalsIgnoreCase(extension)) {
                byte[] bytes = FileManager.readFile((String)fileName, (boolean)true);
                return PDF2ImageConverter.convertPDFIntoThumbImagePNG(bytes, width, height);
            }
            if ("png".equalsIgnoreCase(extension) || "jpg".equalsIgnoreCase(extension) || "jpeg".equalsIgnoreCase(extension) || "gif".equalsIgnoreCase(extension) || "giff".equalsIgnoreCase(extension) || "bmp".equalsIgnoreCase(extension)) {
                byte[] bytes = FileManager.readFile((String)fileName, (boolean)true);
                return ImageShrinker.sizeImage(bytes, width, height, true, false);
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }
}

