/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.prompting.chatgpt;

import java.util.List;
import java.util.Map;
import org.eclnt.ccee.chatgpt.logic.http.HttpCommunicationChatGPT;
import org.eclnt.ccee.chatgpt.logic.http.OpenAIJson;
import org.eclnt.ccee.json.jackson.JSONUtil;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.prompting.PromptingBase;
import org.eclnt.ccee.prompting.PromptingMessage;
import org.eclnt.util.general.IExecuteOnObject;

public class PromptingChatGPT
extends PromptingBase {
    boolean m_initialized = false;
    String m_assistantId;
    String m_threadId;
    int m_lastMessageIndex = -1;

    protected void initialize() {
        if (this.m_initialized) {
            return;
        }
        try {
            this.calculateAssistantId();
            this.calculateThreadId();
            this.m_initialized = true;
        }
        catch (Throwable t) {
            AppLog.L.log(AppLog.LL_INF, "Problem creating instance of PromptinChatGPT", t);
            throw new Error("Problem creating instance of PromptinChatGPT", t);
        }
    }

    protected void calculateAssistantId() {
        String createAssistantRequest = OpenAIJson.instance().createAssistantRequest();
        String response = HttpCommunicationChatGPT.instance().doPost("https://api.openai.com/v1/assistants", createAssistantRequest, null);
        this.m_assistantId = OpenAIJson.instance().parseAssistantResponseForId(response);
    }

    protected void calculateThreadId() {
        String response = HttpCommunicationChatGPT.instance().doPost("https://api.openai.com/v1/threads", null, null);
        this.m_threadId = OpenAIJson.instance().parseThreadsResponseForId(response);
    }

    @Override
    protected void startNewMessageExecute(List<PromptingMessage> messages) {
        this.initialize();
        for (int i = this.m_lastMessageIndex + 1; i < messages.size(); ++i) {
            String messageRole = "user";
            String messageText = messages.get(i).getContent();
            String createMessageRequest = OpenAIJson.instance().createThreadMessage(messageRole, messageText);
            HttpCommunicationChatGPT.instance().doPost("https://api.openai.com/v1/threads/" + this.m_threadId + "/messages", createMessageRequest, null);
        }
        this.m_lastMessageIndex = messages.size() - 1;
        String createRunRequest = OpenAIJson.instance().createRunMessage(this.m_assistantId, true);
        HttpCommunicationChatGPT.instance().doPostWithStreamResponse("https://api.openai.com/v1/threads/" + this.m_threadId + "/runs", createRunRequest, null, new IExecuteOnObject<String>(){

            public void execute(String fragment) {
                if (fragment.startsWith("data: ")) {
                    String content = fragment.substring("data: ".length());
                    if ("[DONE]".equals(content)) {
                        PromptingChatGPT.this.processResponseCompleted();
                    } else {
                        StringBuffer sb = new StringBuffer();
                        Map m = JSONUtil.unmarshalMap(content);
                        if ((m = (Map)m.get("delta")) == null) {
                            return;
                        }
                        List l = (List)m.get("content");
                        for (Object lo : l) {
                            m = (Map)lo;
                            m = (Map)m.get("text");
                            String s = (String)m.get("value");
                            sb.append(s);
                        }
                        PromptingChatGPT.this.processResponseMarkdownFragmentReceived(sb.toString());
                    }
                }
            }
        });
    }
}

