/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.prompting.ollama.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.ccee.json.jackson.JSONUtil;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.prompting.PromptingMessage;
import org.eclnt.ccee.prompting.ollama.http.HttpCommunicationChatBase;
import org.eclnt.ccee.prompting.ollama.http.IHttpCommunicationStreamCallBack;
import org.eclnt.util.general.IExecuteOnObject;

public class HttpCommunicationChatOllama
extends HttpCommunicationChatBase {
    String m_hostOllama = "http://localhost:11434";
    String m_tenantChromaDB = "default_tenant";
    String m_databaseChromaDB = "default_database";
    String m_hostChromaDB = "http://localhost:8000";
    String m_model = "";

    public HttpCommunicationChatOllama(String host, String model, IHttpCommunicationStreamCallBack callBack) {
        super(callBack);
        this.m_hostOllama = host;
        this.m_model = model;
    }

    public PromptingMessage sendChatNoStream(List<PromptingMessage> messages) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("model", this.m_model);
        request.put("messages", messages);
        request.put("stream", false);
        String json = JSONUtil.marshalSimpleObject(request);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String response = this.sendRequest(this.m_hostOllama + "/api/chat", json, headers, true, false, null);
        ArrayList result = new ArrayList();
        Map<String, Object> responseMap = JSONUtil.unmarshalMap(response);
        Map messageMap = (Map)responseMap.get("message");
        String role = (String)messageMap.get("role");
        String content = (String)messageMap.get("content");
        return new PromptingMessage(role, content);
    }

    public void sendChatStream(List<PromptingMessage> messages) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("model", this.m_model);
        request.put("messages", messages);
        request.put("stream", true);
        String json = JSONUtil.marshalSimpleObject(request);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String response = this.sendRequest(this.m_hostOllama + "/api/chat", json, headers, true, true, new IExecuteOnObject<String>(){

            public void execute(String line) {
                HttpCommunicationChatOllama.this.processStreamResponse(line);
            }
        });
    }

    public List<Double> generatedEmbedding(String text) {
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("model", this.m_model);
        request.put("prompt", text);
        String json = JSONUtil.marshalSimpleObject(request);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String response = this.sendRequest(this.m_hostOllama + "/api/embeddings", json, headers, true, false, null);
        ArrayList<Double> result = new ArrayList<Double>();
        Map<String, Object> m = JSONUtil.unmarshalMap(response);
        List l = (List)m.get("embedding");
        for (Object o : l) {
            result.add((Double)o);
        }
        return result;
    }

    protected void processStreamResponse(String line) {
        try {
            Map<String, Object> m = JSONUtil.unmarshalMap(line);
            Map message = (Map)m.get("message");
            String messageText = (String)message.get("content");
            Boolean done = (Boolean)m.get("done");
            if (!Boolean.TRUE.equals(done) && messageText != null) {
                this.m_callBack.onReceivedResponseFragment(messageText);
            } else if (Boolean.TRUE.equals(done)) {
                this.m_callBack.onReceivedResponseCompleted();
            }
        }
        catch (Throwable t) {
            AppLog.L.log(AppLog.LL_INF, "Could not process line: " + line, t);
            throw new Error("Could not process line: " + line, t);
        }
    }
}

