/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.quartz.logic;

import java.util.List;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.db.DBCreateTables;
import org.eclnt.ccee.db.dofw.DOFWSql;
import org.eclnt.ccee.quartz.data.DOJob;
import org.eclnt.ccee.quartz.data.DOJobExecution;
import org.eclnt.ccee.quartz.data.DOJobExecutionProtocol;
import org.eclnt.ccee.quartz.logic.IJobConstants;
import org.eclnt.jsfserver.util.useraccess.TenantAccessMgr;

public class CCEEJobLogic
implements ICCEEConstants,
IJobConstants {
    public static void createUpdateJobTables() {
        new DBCreateTables().createTablesByExplicitResourceFile("org/eclnt/ccee/quartz/data/cceejobtables.sql");
    }

    public static List<DOJob> readAllJobDefinitions() {
        return DOFWSql.query(DOJob.class, null, new Object[]{DOJob.P_ID});
    }

    public static void saveJobDefinition(DOJob jobDefinition) {
        String tenant = TenantAccessMgr.getCurrentTenant();
        jobDefinition.setTenant(tenant);
        DOFWSql.saveObject(jobDefinition);
    }

    public static void deleteJobDefinition(DOJob jobDefinition) {
        DOFWSql.deleteObject(jobDefinition);
    }

    public static List<DOJobExecution> readJobExecutions(Object[] query) {
        String tenant = TenantAccessMgr.getCurrentTenant();
        return DOFWSql.query(DOJobExecution.class, query, new Object[]{DOJobExecution.P_JOBSTARTED});
    }

    public static DOJobExecutionProtocol readProtocol(String id) {
        String tenant = TenantAccessMgr.getCurrentTenant();
        return DOFWSql.queryOne(DOJobExecutionProtocol.class, DOJobExecutionProtocol.P_ID, id);
    }
}

