/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.bridges;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclnt.ccee.ICCEEConstants;

public class LoggerBridge
implements ICCEEConstants {
    static final Object SYNCHER = new Object();
    static final String CLASSNAME_CLog = "org.eclnt.util.log.CLog";
    static final String FIELDNAME_CLog_L = "L";
    static final String METHODNAME_CLog_L_addConsoleHandler = "addConsoleHandler";
    static final String METHODNAME_CLog_L_updateLogLevel = "updateLogLevel";
    static Boolean s_useCLog = null;
    static Method s_CLogMethod_addConsoleHandler = null;
    static Method s_CLogMethod_updateLogLevel = null;
    static Logger s_explicitLogger = null;
    static Logger s_cLogL = null;
    static Logger s_defaultLogger = null;

    public static Logger findLogger() {
        LoggerBridge.initialize();
        if (s_explicitLogger != null) {
            return s_explicitLogger;
        }
        if (s_useCLog.booleanValue()) {
            return s_cLogL;
        }
        return s_defaultLogger;
    }

    public static Logger getExplicitLogger() {
        return s_explicitLogger;
    }

    public static void setExplicitLogger(Logger explicitLogger) {
        s_explicitLogger = explicitLogger;
    }

    public static void initLog2Console() {
        LoggerBridge.initialize();
        if (s_useCLog.booleanValue()) {
            try {
                s_CLogMethod_addConsoleHandler.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void initLogLevel(Level level) {
        LoggerBridge.initialize();
        if (s_useCLog.booleanValue()) {
            try {
                s_CLogMethod_updateLogLevel.invoke(null, level);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        if (s_useCLog == null) {
            Object object = SYNCHER;
            synchronized (object) {
                if (s_useCLog == null) {
                    try {
                        Class<?> c = Class.forName(CLASSNAME_CLog);
                        Field f = c.getField(FIELDNAME_CLog_L);
                        s_cLogL = (Logger)f.get(null);
                        s_CLogMethod_addConsoleHandler = c.getMethod(METHODNAME_CLog_L_addConsoleHandler, new Class[0]);
                        s_CLogMethod_updateLogLevel = c.getMethod(METHODNAME_CLog_L_updateLogLevel, Level.class);
                        s_useCLog = s_cLogL != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    catch (Throwable t) {
                        s_useCLog = false;
                    }
                }
            }
            if (!s_useCLog.booleanValue()) {
                s_defaultLogger = Logger.getLogger("org.eclnt.ccee.default");
                s_defaultLogger.setLevel(LL_INF);
                s_defaultLogger.setUseParentHandlers(false);
            }
        }
    }
}

