/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.chatgpt.logic.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.config.Config;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.file.StreamUtil;
import org.eclnt.util.general.IExecuteOnObject;
import org.eclnt.util.valuemgmt.ValueManager;

public class HttpCommunicationChatGPT
implements ICCEEConstants {
    static HttpCommunicationChatGPT s_instance;
    static String s_dirCommunicationProtocol;
    static String s_openAiCompany;
    static String s_openAiProjectId;
    static String s_openAiApiKey;
    boolean m_withCommunicationProtocol = false;

    public static HttpCommunicationChatGPT instance() {
        return s_instance;
    }

    public static void initialize(String openAiCompany, String openAiProjectId, String openAiApiKey) {
        s_openAiCompany = openAiCompany;
        s_openAiProjectId = openAiProjectId;
        s_openAiApiKey = openAiApiKey;
    }

    public boolean getWithCommunicationProtocol() {
        return this.m_withCommunicationProtocol;
    }

    public void setWithCommunicationProtocol(boolean withCommunicationProtocol) {
        this.m_withCommunicationProtocol = withCommunicationProtocol;
    }

    public byte[] readURLByteArray(String url) {
        try {
            this.checkOpenAiConfiguration();
            URL targetURL = new URL(url);
            this.writeCommunicationProtocol(true, targetURL.toString(), null);
            HttpURLConnection con = (HttpURLConnection)targetURL.openConnection();
            con.setRequestMethod("GET");
            con.setDoOutput(true);
            InputStream is = con.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamUtil.transferStreamContent((InputStream)is, (OutputStream)bos);
            byte[] result = bos.toByteArray();
            this.writeCommunicationProtocol(false, targetURL.toString(), "Byte array: " + result.length);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Problem calling url: " + url, t);
        }
    }

    public String doGet(String uri, Map<String, String> headers) {
        return this.sendRequest(uri, null, headers, false);
    }

    public String doPost(String uri, String body, Map<String, String> headers) {
        return this.sendRequest(uri, body, headers, true);
    }

    public String doPostWithStreamResponse(String uri, String body, Map<String, String> headers, IExecuteOnObject<String> fragmentExecutor) {
        return this.sendRequest(uri, body, headers, true, true, fragmentExecutor);
    }

    private String sendRequest(String url, String body, Map<String, String> headers, boolean asPost) {
        return this.sendRequest(url, body, headers, asPost, false, null);
    }

    private String sendRequest(String url, String body, Map<String, String> headers, boolean asPost, boolean inFragments, IExecuteOnObject<String> executor) {
        try {
            this.checkOpenAiConfiguration();
            headers = this.addChatGPTHeaders(headers, null);
            URL targetURL = new URL(url);
            HttpURLConnection con = (HttpURLConnection)targetURL.openConnection();
            String requestJson = body == null ? "" : body;
            this.writeCommunicationProtocol(true, targetURL.toString(), requestJson);
            if (asPost) {
                con.setRequestMethod("POST");
            } else {
                con.setRequestMethod("GET");
            }
            con.setDoOutput(true);
            if (headers != null) {
                for (String headerKey : headers.keySet()) {
                    String headerValue = headers.get(headerKey);
                    con.setRequestProperty(headerKey, headerValue);
                }
            }
            if (body != null) {
                byte[] bodyBytes = body.getBytes(ValueManager.CHARSET_UTF8);
                ByteArrayInputStream bis = new ByteArrayInputStream(bodyBytes);
                StreamUtil.transferStreamContent((InputStream)bis, (OutputStream)con.getOutputStream());
            }
            InputStream is = con.getInputStream();
            if (inFragments) {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, ValueManager.CHARSET_UTF8));
                    while ((line = reader.readLine()) != null) {
                        this.writeCommunicationProtocol(false, targetURL.toString(), line);
                        if (executor == null) continue;
                        executor.execute((Object)line);
                    }
                    return "";
                }
                catch (Throwable t) {
                    AppLog.L.log(AppLog.LL_INF, "Problem processing stream.", t);
                    throw new Error("Problem processing stream.", t);
                }
            }
            byte[] responseBytes = StreamUtil.transferStreamContentIntoBytes((InputStream)is);
            String json = new String(responseBytes, ValueManager.CHARSET_UTF8);
            this.writeCommunicationProtocol(false, targetURL.toString(), json);
            return json;
        }
        catch (Throwable t) {
            throw new Error("Problem processing: " + url, t);
        }
    }

    private Map<String, String> addChatGPTHeaders(Map<String, String> headers, String contentType) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("Authorization", "Bearer " + s_openAiApiKey);
        headers.put("OpenAI-Project", s_openAiProjectId);
        if (contentType == null) {
            headers.put("Content-Type", "application/json");
        } else {
            headers.put("Content-Type", contentType);
        }
        headers.put("OpenAI-Beta", "assistants=v2");
        return headers;
    }

    private void writeCommunicationProtocol(boolean isRequest, String url, String request) {
        if (!this.m_withCommunicationProtocol) {
            return;
        }
        String date = ValueManager.convertObject2DisplayString((Object)new Date(), (String)"datetime", (String)"yyyyMMdd_HHmmssSSS", (String)TimeZone.getDefault().getID(), (boolean)false);
        String fileUrl = ValueManager.convertStringIntoFileName((String)url, (boolean)false);
        String fileName = null;
        fileName = isRequest ? s_dirCommunicationProtocol + date + "_request_" + fileUrl + ".txt" : s_dirCommunicationProtocol + date + "_response_" + fileUrl + ".txt";
        fileName = ValueManager.encodeIntoValidFileName((String)fileName, (boolean)false);
        FileManager.ensureDirectoryForFileExists((String)fileName);
        request = request != null ? "URL: " + url + "\n\n" + request : "URL: " + url + "\n\n";
        FileManager.writeUTF8File((String)fileName, (String)request, (boolean)false);
    }

    private void checkOpenAiConfiguration() {
        if (s_openAiApiKey == null || s_openAiProjectId == null || s_openAiCompany == null) {
            throw new Error("OpenAI not correctly setup: you need to configure apiKey, projectId, company.");
        }
    }

    static {
        String openAiCompany;
        String openAiApiKey;
        s_instance = new HttpCommunicationChatGPT();
        s_openAiCompany = null;
        s_openAiProjectId = null;
        s_openAiApiKey = null;
        s_dirCommunicationProtocol = HttpSessionAccess.getServletTempDirectory() + "/chatgpt/httplog/";
        s_dirCommunicationProtocol = ValueManager.encodeIntoValidFileName((String)s_dirCommunicationProtocol, (boolean)true);
        FileManager.ensureDirectoryExists((String)s_dirCommunicationProtocol);
        String openAiProjectId = Config.getConfigValue("openai_projectid");
        if (openAiProjectId != null) {
            s_openAiProjectId = openAiProjectId;
        }
        if ((openAiApiKey = Config.getConfigValue("openai_apikey")) != null) {
            s_openAiApiKey = openAiApiKey;
        }
        if ((openAiCompany = Config.getConfigValue("openai_company")) != null) {
            s_openAiCompany = openAiCompany;
        }
    }
}

