/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.dofw;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.db.dofw.DBConnectionPoolDefaultAccessKeyBuilder;
import org.eclnt.ccee.db.dofw.DBConnectionPoolDefaultConnectionChecker;
import org.eclnt.ccee.db.dofw.IDBConnectionPoolAccessKeyBuilder;
import org.eclnt.ccee.db.dofw.IDBConnectionPoolConnectionChecker;
import org.eclnt.ccee.log.AppLog;

public class DBConnectionPool
implements ICCEEConstants {
    static IDBConnectionPoolConnectionChecker s_connectionChecker = new DBConnectionPoolDefaultConnectionChecker();
    static IDBConnectionPoolAccessKeyBuilder s_accessKeyBuilder = new DBConnectionPoolDefaultAccessKeyBuilder();
    private static final Object SYNCHER = new Object();
    static Hashtable<String, List<Connection>> s_contextPools = new Hashtable();

    public static void initConnectionChecker(IDBConnectionPoolConnectionChecker connectionChecker) {
        s_connectionChecker = connectionChecker;
        if (s_connectionChecker == null) {
            s_connectionChecker = new DBConnectionPoolDefaultConnectionChecker();
        }
    }

    public static void initAccessKeyBuilder(IDBConnectionPoolAccessKeyBuilder accessKeyBuilder) {
        s_accessKeyBuilder = accessKeyBuilder;
        if (s_accessKeyBuilder == null) {
            s_accessKeyBuilder = new DBConnectionPoolDefaultAccessKeyBuilder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToPool(String contextName, Connection conn) {
        try {
            conn.rollback();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Object object = SYNCHER;
        synchronized (object) {
            String key = DBConnectionPool.buildPoolAccessKey(contextName);
            List<Connection> conns = s_contextPools.get(key);
            if (conns == null) {
                conns = new ArrayList<Connection>();
            }
            s_contextPools.put(key, conns);
            conns.add(conn);
            AppLog.L.info("DBConnectionPool, " + contextName + ", number of pooled connections: " + conns.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection pickFromPool(String contextName) {
        Connection result = null;
        Object object = SYNCHER;
        synchronized (object) {
            String key = DBConnectionPool.buildPoolAccessKey(contextName);
            List<Connection> conns = s_contextPools.get(key);
            if (conns == null) {
                return null;
            }
            if (conns.size() == 0) {
                return null;
            }
            result = conns.get(0);
            conns.remove(0);
        }
        boolean connectionCheckResult = false;
        try {
            connectionCheckResult = s_connectionChecker.checkConnection(result);
        }
        catch (Throwable t) {
            connectionCheckResult = false;
        }
        if (!connectionCheckResult) {
            result = DBConnectionPool.pickFromPool(contextName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllConnections() {
        Object object = SYNCHER;
        synchronized (object) {
            for (String key : s_contextPools.keySet()) {
                List<Connection> conns = s_contextPools.get(key);
                if (conns == null) continue;
                for (Connection conn : conns) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {}
                }
                conns.clear();
            }
            s_contextPools.clear();
        }
    }

    private static String buildPoolAccessKey(String contextName) {
        return s_accessKeyBuilder.buildAccessKey(contextName);
    }
}

