/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.db.DBAccess;
import org.eclnt.ccee.db.DBAction;
import org.eclnt.ccee.db.dofw.DOFWDialect;
import org.eclnt.ccee.db.jdbc.JDBCColumnInfo;
import org.eclnt.ccee.db.jdbc.JDBCTableInfo;
import org.eclnt.ccee.db.util.QueryUtils;
import org.eclnt.util.valuemgmt.ValueManager;

public class JDBCUtils
implements ICCEEConstants {
    public static Map<String, List<JDBCColumnInfo>> s_buffer = new Hashtable<String, List<JDBCColumnInfo>>();

    public static List<JDBCTableInfo> findTables() {
        return JDBCUtils.findTables("CCEE_DEFAULTCONTEXT");
    }

    public static void resetBuffer() {
        s_buffer.clear();
    }

    public static List<JDBCTableInfo> findTables(String contextName) {
        try {
            Connection conn = DBAccess.createConnection(contextName);
            DatabaseMetaData dmd = conn.getMetaData();
            ResultSet rs = dmd.getTables(null, null, "%", new String[]{"TABLE"});
            ArrayList<JDBCTableInfo> result = new ArrayList<JDBCTableInfo>();
            while (rs.next()) {
                JDBCTableInfo ti = new JDBCTableInfo();
                ti.setName(rs.getString("TABLE_NAME"));
                result.add(ti);
            }
            return result;
        }
        catch (Throwable t) {
            throw new Error("Problem finding result set metadata for " + contextName, t);
        }
    }

    public static List<JDBCColumnInfo> findColumnsOfTable(String tableName) {
        return JDBCUtils.findColumnsOfTable("CCEE_DEFAULTCONTEXT", tableName);
    }

    public static List<JDBCColumnInfo> findColumnsOfTable(String tableName, boolean withSorting) {
        return JDBCUtils.findColumnsOfTable("CCEE_DEFAULTCONTEXT", tableName, withSorting);
    }

    public static JDBCColumnInfo findColumnInfo(String tableName, String columnName) {
        return JDBCUtils.findColumnInfo("CCEE_DEFAULTCONTEXT", tableName, columnName);
    }

    public static JDBCColumnInfo findColumnInfo(String contextName, String tableName, String columnName) {
        try {
            List<JDBCColumnInfo> cis = JDBCUtils.findColumnsOfTable(contextName, tableName);
            for (JDBCColumnInfo ci : cis) {
                if (!ValueManager.checkIfStringsAreEqual((String)columnName, (String)ci.getName())) continue;
                return ci;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static List<JDBCColumnInfo> findColumnsOfTable(String contextName, String tableName) {
        return JDBCUtils.findColumnsOfTable(contextName, tableName, true);
    }

    public static List<JDBCColumnInfo> findColumnsOfTable(final String contextName, final String tableName, boolean withSorting) {
        List<JDBCColumnInfo> bufferedResult = s_buffer.get(contextName + "/" + tableName);
        if (bufferedResult != null) {
            return bufferedResult;
        }
        final ArrayList<JDBCColumnInfo> result = new ArrayList<JDBCColumnInfo>();
        try {
            new DBAction(contextName){

                @Override
                protected void run() throws Exception {
                    Connection conn = this.getConnection();
                    DatabaseMetaData dmd = conn.getMetaData();
                    String tableNameForAnalysis = tableName;
                    if (!DOFWDialect.checkIfTableColumnNamesAreCaseSensitive(contextName)) {
                        tableNameForAnalysis = ValueManager.toUpperCaseId((String)tableName);
                    }
                    ResultSet rs = dmd.getColumns(null, null, tableNameForAnalysis, null);
                    HashSet<String> processedNames = new HashSet<String>();
                    while (rs.next()) {
                        JDBCColumnInfo ci = new JDBCColumnInfo();
                        ci.setName(rs.getString("COLUMN_NAME"));
                        ci.setDataType(rs.getInt("DATA_TYPE"));
                        ci.setTypeName(rs.getString("TYPE_NAME"));
                        ci.setColumnSize(rs.getInt("COLUMN_SIZE"));
                        if (processedNames.contains(ci.getName())) continue;
                        result.add(ci);
                        processedNames.add(ci.getName());
                    }
                }
            };
        }
        catch (Throwable t) {
            throw new Error("Problem finding result set metadata for " + contextName + ", " + tableName, t);
        }
        if (withSorting) {
            Collections.sort(result, new Comparator<JDBCColumnInfo>(){

                @Override
                public int compare(JDBCColumnInfo o1, JDBCColumnInfo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        s_buffer.put(contextName + "/" + tableName, result);
        return result;
    }

    public static Object[] transferSortStringIntoJDBCQueryObjects(String orderBy) {
        return QueryUtils.transferSortStringIntoQueryObjects(orderBy);
    }

    public static Object[] transferSortStringIntoJDBCQueryObjects(String[] orderBy) {
        return QueryUtils.transferSortStringIntoQueryObjects(orderBy);
    }

    public static Object[] transferQueryStringIntoJDBCQueryObjects(final String contextName, String tableName, String query) {
        return QueryUtils.transferQueryStringIntoQueryObjects(tableName, query, new QueryUtils.IValueClassProvider(){

            @Override
            public Class findTypeForProperty(String structureName, String propertyName) {
                try {
                    JDBCColumnInfo ci = JDBCUtils.findColumnInfo(contextName, structureName, propertyName);
                    if (ci != null && ci.getDataType() != null) {
                        return JDBCUtils.convertJdbcDataTypeToJavaDataType(ci.getDataType());
                    }
                    return String.class;
                }
                catch (Throwable t) {
                    throw new Error("Could not find class for property: " + structureName + ", " + propertyName, t);
                }
            }
        });
    }

    public static Object[] transferQueryStringIntoJDBCQueryObjects(final String contextName, String tableName, String[] query) {
        return QueryUtils.transferQueryStringIntoQueryObjects(tableName, query, new QueryUtils.IValueClassProvider(){

            @Override
            public Class findTypeForProperty(String structureName, String propertyName) {
                try {
                    JDBCColumnInfo ci = JDBCUtils.findColumnInfo(contextName, structureName, propertyName);
                    if (ci != null && ci.getDataType() != null) {
                        return JDBCUtils.convertJdbcDataTypeToJavaDataType(ci.getDataType());
                    }
                    return String.class;
                }
                catch (Throwable t) {
                    throw new Error("Could not find class for property: " + structureName + ", " + propertyName, t);
                }
            }
        });
    }

    public static Class convertJdbcDataTypeToJavaDataType(int jdbcType) {
        switch (jdbcType) {
            case 8: {
                return Double.class;
            }
            case 6: {
                return Float.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return BigInteger.class;
            }
            case 3: {
                return BigDecimal.class;
            }
        }
        return String.class;
    }
}

