/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.dyndata;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.dyndata.DynDataReaderContext;
import org.eclnt.ccee.dyndata.DynDataUtil;
import org.eclnt.ccee.dyndata.functions.FunctionExecutor;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class DynDataMap
extends HashMap<String, Object>
implements ICCEEConstants {
    public static final String KEY_DATA = "data";
    DynDataReaderContext m_ddrContext;
    DynDataMap m_parent;
    String m_dataDefinitionId;
    Stack<DynDataMap> m_currentDataRequestEntryPointStack = new Stack();

    public DynDataMap(DynDataReaderContext ddrContext, String dataDefinitionId, DynDataMap parentDataMap) {
        this.m_ddrContext = ddrContext;
        this.m_dataDefinitionId = dataDefinitionId;
        this.m_parent = parentDataMap;
        if (this.m_parent != null) {
            this.m_currentDataRequestEntryPointStack = this.m_parent.m_currentDataRequestEntryPointStack;
        }
        this.put(KEY_DATA, this);
    }

    public DynDataMap getParent() {
        return this.m_parent;
    }

    public void setParent(DynDataMap parent) {
        this.m_parent = parent;
        if (this.m_parent != null) {
            this.m_currentDataRequestEntryPointStack = this.m_parent.m_currentDataRequestEntryPointStack;
        }
    }

    public String getDataDefinitionId() {
        return this.m_dataDefinitionId;
    }

    public DynDataMap getCurrentDataRequestEntryPoint() {
        return this.m_currentDataRequestEntryPointStack.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        Object result = super.get(key);
        if (result == null) {
            String keyString = (String)key;
            if (DynDataUtil.checkIfDataExpression(key.toString())) {
                String[] keys = DynDataUtil.getKeysOfDataExpression(keyString);
                try {
                    this.m_currentDataRequestEntryPointStack.push(this);
                    Object object = this.getAttributeValueForChainOfKeys(keys);
                    return object;
                }
                catch (Throwable t) {
                    AppLog.L.log(AppLog.LL_INF, "Problem processing expression key: " + keyString, t);
                }
                finally {
                    this.m_currentDataRequestEntryPointStack.pop();
                }
            }
            if (keyString.contains("(") && keyString.endsWith(")")) {
                try {
                    String methodName = ValueManager.decodeMethodName((String)keyString);
                    String[] methodParams = ValueManager.decodeMethodParams((String)keyString);
                    result = this.executeMethod(this.m_ddrContext, this, methodName, methodParams);
                }
                catch (Throwable t) {
                    AppLog.L.log(LL_INF, "Problem executing method: " + key, t);
                }
            } else if (keyString.contains(":")) {
                Object realValue;
                String realKey = null;
                String format = null;
                String formatmask = null;
                String timezone = null;
                String[] parts = ValueManager.tokenizeStringWithQuotes((String)keyString, (char)':');
                if (parts.length > 0 && parts[0].length() > 0) {
                    realKey = parts[0];
                }
                if (parts.length > 1 && parts[1].length() > 0) {
                    format = parts[1];
                }
                if (parts.length > 2 && parts[2].length() > 0) {
                    formatmask = parts[2];
                }
                if (parts.length > 3 && parts[3].length() > 0) {
                    timezone = parts[3];
                }
                if (realKey != null && (realValue = this.getContent(realKey)) != null) {
                    if (ValueManager.isNotEmpty((String)format)) {
                        if (ValueManager.isEmpty((String)formatmask)) {
                            if ("date".equals(format)) {
                                formatmask = this.m_ddrContext.getFormatmaskDate();
                            } else if ("time".equals(format)) {
                                formatmask = this.m_ddrContext.getFormatmaskTime();
                            } else if ("datetime".equals(format)) {
                                formatmask = this.m_ddrContext.getFormatmaskDateTime();
                            } else if (ValueManager.checkIfFormatIsNumericNoDecimals((String)format)) {
                                formatmask = this.m_ddrContext.getFormatmaskInt();
                            } else if (ValueManager.checkIfFormatIsNumericWithDecimals((String)format)) {
                                formatmask = this.m_ddrContext.getFormatmaskDecimal();
                            }
                        }
                        if (ValueManager.isEmpty((String)timezone)) {
                            timezone = this.m_ddrContext.getTimezone();
                        }
                    }
                    result = ValueManager.convertObject2DisplayString((Object)realValue, (String)format, (String)formatmask, (String)timezone, (boolean)true);
                }
            }
        } else if (result instanceof LocalDate || result instanceof Date) {
            result = ValueManager.convertObject2ClientDisplayString(result, (String)"date", (String)this.m_ddrContext.getFormatmaskDate(), (String)TimeZone.getDefault().getID(), (boolean)false, (boolean)false);
        } else if (result instanceof LocalTime) {
            result = ValueManager.convertObject2ClientDisplayString(result, (String)"time", (String)this.m_ddrContext.getFormatmaskTime(), (String)TimeZone.getDefault().getID(), (boolean)false, (boolean)false);
        } else if (result instanceof LocalDateTime) {
            result = ValueManager.convertObject2ClientDisplayString(result, (String)"datetime", (String)this.m_ddrContext.getFormatmaskDateTime(), (String)TimeZone.getDefault().getID(), (boolean)false, (boolean)false);
        } else if (result instanceof BigDecimal || result instanceof Float || result instanceof Double) {
            result = ValueManager.convertObject2ClientDisplayString(result, (String)"bigdecimal", (String)this.m_ddrContext.getFormatmaskDecimal(), null, (boolean)false, (boolean)false);
        } else if (result instanceof BigInteger || result instanceof Integer || result instanceof Long || result instanceof Byte) {
            result = ValueManager.convertObject2ClientDisplayString(result, (String)"int", (String)this.m_ddrContext.getFormatmaskInt(), null, (boolean)false, (boolean)false);
        }
        return result;
    }

    public Object getContent(Object key) {
        String keyString = "" + key;
        if (keyString.contains("(") && keyString.endsWith(")")) {
            try {
                String methodName = ValueManager.decodeMethodName((String)keyString);
                String[] methodParams = ValueManager.decodeMethodParams((String)keyString);
                Object result = this.executeMethod(this.m_ddrContext, this, methodName, methodParams);
                return result;
            }
            catch (Throwable t) {
                AppLog.L.log(LL_INF, "Problem executing method: " + key, t);
            }
        }
        return super.get(key);
    }

    public Object getAttributeValue(String name) {
        return this.get(name);
    }

    public DynDataMap getObjectMap(String dataDefinitionId) {
        return (DynDataMap)this.get(dataDefinitionId);
    }

    public List<DynDataMap> getObjectMapList(String dataDefinitionId) {
        return (List)this.get(dataDefinitionId);
    }

    public Object getAttributeValueForChainOfKeys(String[] keys) {
        if (keys == null) {
            return null;
        }
        Object result = this;
        for (String key : keys) {
            if (key == null) {
                return null;
            }
            if (result instanceof DynDataMap) {
                result = ((DynDataMap)result).get(key);
            }
            if (result == null) {
                return null;
            }
            if (!(result instanceof DynDataMap)) break;
        }
        return result;
    }

    public Object getExpressionValue(String expression) {
        if (expression == null) {
            return null;
        }
        if (DynDataUtil.checkIfDataExpression(expression)) {
            String inner = expression.substring(2, expression.length() - 1);
            StringTokenizer tokenizer = new StringTokenizer(inner, ".");
            DynDataMap current = this;
            Object val = null;
            while (tokenizer.hasMoreTokens()) {
                val = current.get(tokenizer.nextToken());
                if (val == null) {
                    return null;
                }
                if (val instanceof DynDataMap) {
                    current = (DynDataMap)val;
                    continue;
                }
                if (ValueManager.checkIfSimpleDataType(val.getClass())) {
                    return val;
                }
                return null;
            }
            return val;
        }
        return null;
    }

    public String toString(int level) {
        Object value;
        String prefix = "";
        for (int i = 0; i < level; ++i) {
            prefix = prefix + "    ";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        sb.append(this.m_dataDefinitionId + ": ");
        ArrayList<String> keyList = new ArrayList<String>();
        for (String key : this.keySet()) {
            if (KEY_DATA.equals(key)) continue;
            keyList.add(key);
        }
        Collections.sort(keyList);
        for (String key : keyList) {
            value = this.get(key);
            if (value == null || !ValueManager.checkIfSimpleDataType(value.getClass())) continue;
            sb.append(key);
            sb.append("=");
            sb.append(this.get(key) + " ");
        }
        sb.append("\n");
        for (String key : keyList) {
            value = this.get(key);
            if (value == null || !(value instanceof DynDataMap)) continue;
            sb.append(((DynDataMap)value).toString(level + 1));
        }
        for (String key : keyList) {
            value = this.get(key);
            if (value == null || !(value instanceof List)) continue;
            for (Object item : (List)value) {
                sb.append(((DynDataMap)item).toString(level + 1));
            }
        }
        return sb.toString();
    }

    private Object executeMethod(DynDataReaderContext ddrContext, DynDataMap dynDataMap, String methodName, String[] methodParams) {
        return FunctionExecutor.executeMethod(ddrContext, dynDataMap, methodName, methodParams);
    }
}

