/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.dyndata;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.bridges.ClassLoaderBridge;
import org.eclnt.ccee.db.dofw.DOFWProperty;
import org.eclnt.ccee.db.dofw.DOFWRepository;
import org.eclnt.ccee.db.jdbc.JDBCColumnInfo;
import org.eclnt.ccee.db.jdbc.JDBCUtils;
import org.eclnt.ccee.dyndata.DynDataAttribute;
import org.eclnt.ccee.dyndata.DynDataMap;
import org.eclnt.ccee.dyndata.DynDataReader;
import org.eclnt.ccee.dyndata.DynDataReaderContext;
import org.eclnt.ccee.dyndata.creation.ICreatePreviewTestObject;
import org.eclnt.ccee.dyndata.meta.DynDataDefinition;
import org.eclnt.ccee.dyndata.meta.DynDataDefinitionAttribute;
import org.eclnt.ccee.dyndata.meta.ENUMFileReadingType;
import org.eclnt.ccee.dyndata.meta.ENUMPropertyFileReadingType;
import org.eclnt.ccee.dyndata.meta.IDynDataConstants;
import org.eclnt.ccee.dyndata.properties.PropertyAccess;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.xml.JAXBUtil;
import org.eclnt.jsfserver.streamstore.IStreamStore;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.jsfserver.util.BeanIntrospector;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.PojoManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class DynDataUtil
implements ICCEEConstants,
IDynDataConstants {
    public static DynDataDefinition parseDynDataDefinitionXml(String xml) {
        return JAXBUtil.unmarshalSimpleObject(xml, DynDataDefinition.class);
    }

    public static String marshalDynDataDefinition(DynDataDefinition ddd) {
        return JAXBUtil.marshalSimpleObject(ddd);
    }

    public static DynDataDefinition findChildDynDataDefinition(DynDataDefinition ddd, String childId) {
        for (DynDataDefinition childDdd : ddd.getChildren()) {
            if (!ValueManager.checkIfStringsAreEqual((String)childDdd.getId(), (String)childId)) continue;
            return childDdd;
        }
        return null;
    }

    public static List<DynDataAttribute> readAttributesOfDynDataDefinition(DynDataReaderContext ddrContext, DynDataDefinition ddd) {
        return DynDataUtil.readAttributesOfDynDataDefinition(ddrContext, ddd, true);
    }

    public static List<DynDataAttribute> readAttributesOfDynDataDefinition(DynDataReaderContext ddrContext, DynDataDefinition ddd, boolean withVirtualAttributes) {
        DynDataAttribute dda;
        DynDataAttribute dda2;
        ResourceBundle rb;
        ArrayList<DynDataAttribute> result = new ArrayList<DynDataAttribute>();
        HashSet<String> allNames = new HashSet<String>();
        if (ddd.getClassName() != null) {
            List<DynDataAttribute> propertyAttributes = DynDataUtil.readAllPropertiyAttributesOfClass(ddd.getClassName());
            for (DynDataAttribute att : propertyAttributes) {
                result.add(att);
                allNames.add(att.getName());
            }
        }
        if (ddd.getPropertyFilePath() != null && (rb = DynDataUtil.readPropertyFile(ddd, ddrContext)) != null) {
            Enumeration<String> enumKeys = rb.getKeys();
            while (enumKeys.hasMoreElements()) {
                String key = enumKeys.nextElement();
                if (allNames.contains(key)) continue;
                dda2 = new DynDataAttribute();
                dda2.setClassName(String.class.toString());
                dda2.setKey(false);
                dda2.setName(key);
                result.add(dda2);
                allNames.add(dda2.getName());
            }
        }
        if (ddd.getTableName() != null) {
            try {
                List<JDBCColumnInfo> cis = JDBCUtils.findColumnsOfTable(DynDataUtil.findDataContextName(ddrContext, ddd), ddd.getTableName());
                for (JDBCColumnInfo ci : cis) {
                    dda2 = new DynDataAttribute();
                    dda2.setClassName("");
                    dda2.setName(ci.getName());
                    dda2.setKey(false);
                    result.add(dda2);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        for (DynDataDefinitionAttribute att : ddd.getAttributes()) {
            if (att.getName() == null || allNames.contains(att.getName())) continue;
            dda = new DynDataAttribute();
            dda.setName(att.getName());
            dda.setClassName(att.getClassName());
            result.add(dda);
        }
        if (withVirtualAttributes) {
            for (DynDataDefinitionAttribute att : ddd.getVirtualAttributes()) {
                if (att.getName() == null || allNames.contains(att.getName())) continue;
                dda = new DynDataAttribute();
                dda.setName(att.getName());
                dda.setClassName(att.getClassName());
                result.add(dda);
            }
        }
        Collections.sort(result);
        return result;
    }

    public static DynDataDefinition createDemoDDD() {
        String path = DynDataUtil.class.getPackage().getName().replace(".", "/") + "/resources/demo.xml";
        String xml = new ClassloaderReader(true).readUTF8File(path, true);
        return DynDataUtil.parseDynDataDefinitionXml(xml);
    }

    public static List<DynDataDefinitionAttribute> readVirtualAttributesFromJavaScript(String script) {
        ArrayList<DynDataDefinitionAttribute> result = new ArrayList<DynDataDefinitionAttribute>();
        if (script != null) {
            int currentIndex = 0;
            while ((currentIndex = script.indexOf("data.put(", currentIndex)) >= 0) {
                int nextIndex = script.indexOf(",", currentIndex + 9);
                if (nextIndex >= 0) {
                    String name = script.substring(currentIndex + 9, nextIndex);
                    name = name.replace("'", "");
                    name = name.replace("\"", "");
                    name = name.replace(" ", "");
                    result.add(new DynDataDefinitionAttribute(name, null));
                }
                currentIndex += "data.put(".length();
            }
        }
        return result;
    }

    public static DynDataMap readRootObject(DynDataReaderContext dddReaderContext, DynDataDefinition ddd) {
        DynDataReader ddr = new DynDataReader(dddReaderContext);
        return ddr.createDynDataMap(ddd);
    }

    public static boolean checkIfRootIsManagedByDOFW(DynDataDefinition ddd) {
        try {
            if (ddd.getClassName() == null) {
                throw new Exception("Missing entity class name in root definition.");
            }
            Class<?> clazz = Class.forName(ddd.getClassName(), true, ClassLoaderBridge.findCurrentClassLoader());
            return DOFWRepository.getEntity(clazz) != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean checkIfDataExpression(String s) {
        if (s == null) {
            return false;
        }
        return s.startsWith("#{") && s.endsWith("}");
    }

    public static String[] getKeysOfDataExpression(String s) {
        if (s == null) {
            return null;
        }
        if (!DynDataUtil.checkIfDataExpression(s)) {
            return null;
        }
        s = s.substring(2, s.length() - 1);
        int expressionLevel = 0;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < s.length(); ++i) {
            char ci = s.charAt(i);
            int cip1 = 32;
            if (i < s.length() - 1) {
                cip1 = s.charAt(i + 1);
            }
            if (ci == '#' && cip1 == 123) {
                ++expressionLevel;
                continue;
            }
            if (ci == '}') {
                --expressionLevel;
                continue;
            }
            if (ci != '.' || expressionLevel != 0) continue;
            indices.add(i);
        }
        if (!s.endsWith(".")) {
            indices.add(s.length());
        }
        String[] result = new String[indices.size()];
        int currentIndex = 0;
        for (int i = 0; i < indices.size(); ++i) {
            result[i] = s.substring(currentIndex, (Integer)indices.get(i));
            currentIndex = (Integer)indices.get(i) + 1;
        }
        return result;
    }

    public static boolean checkIfKey(Class clazz, String propertyName) {
        try {
            if (clazz == null) {
                return false;
            }
            if (propertyName == null) {
                return false;
            }
            List<DOFWProperty> kps = DOFWRepository.getKeyProperties(clazz);
            for (DOFWProperty kp : kps) {
                if (!kp.getName().equals(propertyName)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static ResourceBundle readPropertyFile(DynDataDefinition ddd, DynDataReaderContext ddrContext) {
        if (ddrContext == null) {
            ddrContext = new DynDataReaderContext();
        }
        if (ddd.getPropertyFilePath() == null) {
            return null;
        }
        if (ddd.getPropertyFileReadingType() == null) {
            return null;
        }
        try {
            if (ddd.getPropertyFileReadingType() == null || ddd.getPropertyFileReadingType() == ENUMPropertyFileReadingType.PROPERTYACCESSINTERFACE) {
                String contentString = DynDataUtil.readCombinedMultiLanguagePropertyFileByInterface(ddd, ddrContext);
                if (contentString == null) {
                    throw new Exception("Property file is not available by property-access-interface: " + ddd.getPropertyFilePath());
                }
                byte[] content = contentString.getBytes("UTF-8");
                InputStreamReader contentReader = new InputStreamReader((InputStream)new ByteArrayInputStream(content), Charset.forName("UTF-8"));
                PropertyResourceBundle result = new PropertyResourceBundle(contentReader);
                return result;
            }
            if (ddd.getPropertyFileReadingType() == ENUMPropertyFileReadingType.RESOURCE) {
                ResourceBundle result = ResourceBundle.getBundle(ddd.getPropertyFilePath(), ddrContext.getLocale(), ClassLoaderBridge.findCurrentClassLoader());
                return result;
            }
            if (ddd.getPropertyFileReadingType() == ENUMPropertyFileReadingType.STREAMSTORE || ddd.getPropertyFileReadingType() == ENUMPropertyFileReadingType.FILE) {
                String content = DynDataUtil.readPropertyFileTextOfDynDataDefinition(ddrContext, ddd, true);
                StringReader contentReader = new StringReader(content);
                PropertyResourceBundle result = new PropertyResourceBundle(contentReader);
                return result;
            }
            throw new Error("Unknown property file reading type: " + (Object)((Object)ddd.getPropertyFileReadingType()));
        }
        catch (Throwable t) {
            AppLog.L.log(LL_INF, "Problem transferring property file content into dynamic data map: " + ddd.getId(), t);
            return null;
        }
    }

    public static void savePropertyFile(DynDataReaderContext ddrContext, DynDataDefinition ddd, String text, boolean withError) {
        if (ddd.getPropertyFileReadingType() == ENUMPropertyFileReadingType.FILE) {
            DynDataUtil.writeFile(ENUMFileReadingType.FILE, ddd.getPropertyFilePath(), ddrContext.getPropertyFileRootDirectory(), "ccsjrxml/propertyFiles/", text);
        } else if (ddd.getPropertyFileReadingType() == ENUMPropertyFileReadingType.STREAMSTORE) {
            DynDataUtil.writeFile(ENUMFileReadingType.STREAMSTORE, ddd.getPropertyFilePath(), ddrContext.getPropertyFileRootDirectory(), "ccsjrxml/propertyFiles/", text);
        } else if (withError) {
            throw new Error("Cannost save file with reading type: " + (Object)((Object)ddd.getPropertyFileReadingType()) + ", only FILE is supported");
        }
    }

    public static void transferSimpleXMLElementToMap(Map<String, Object> map, SimpleXMLElement sx) {
        map.putAll(sx.getValueMap());
        for (SimpleXMLElement subSx : sx.getSubElements()) {
            String name = subSx.getName();
            if ("list".equals(name)) {
                ArrayList<HashMap<String, Object>> l = new ArrayList<HashMap<String, Object>>();
                int counter = 0;
                for (SimpleXMLElement childSx : subSx.getSubElements()) {
                    if (counter == 0) {
                        String childName = childSx.getName();
                        map.put(childName, l);
                    }
                    HashMap<String, Object> childMap = new HashMap<String, Object>();
                    l.add(childMap);
                    DynDataUtil.transferSimpleXMLElementToMap(childMap, childSx);
                    ++counter;
                }
                continue;
            }
            HashMap<String, Object> subMap = new HashMap<String, Object>();
            map.put(name, subMap);
            DynDataUtil.transferSimpleXMLElementToMap(subMap, subSx);
        }
    }

    public static String readJsonFileOfDynDataDefinition(DynDataReaderContext ddrContext, DynDataDefinition ddd, boolean withError) {
        try {
            return DynDataUtil.readFile(ddd.getJsonFileReadingType(), ddd.getJsonFilePath(), ddrContext.getJsonFileRootDirectory(), "ccsjrxml/jsonFiles/");
        }
        catch (Throwable t) {
            if (!withError) {
                return null;
            }
            throw new Error("Could not read JSON file: " + (Object)((Object)ddd.getJsonFileReadingType()) + ", " + ddd.getJsonFilePath(), t);
        }
    }

    public static String readPropertyFileTextOfDynDataDefinition(DynDataReaderContext ddrContext, DynDataDefinition ddd, boolean withError) {
        if (ddd.getPropertyFileReadingType() != ENUMPropertyFileReadingType.FILE && ddd.getPropertyFileReadingType() != ENUMPropertyFileReadingType.STREAMSTORE) {
            throw new Error("Reading of text of property file is only supported with types: FILE, STREAMSTORE");
        }
        try {
            switch (ddd.getPropertyFileReadingType()) {
                case STREAMSTORE: {
                    return DynDataUtil.readFile(ENUMFileReadingType.STREAMSTORE, ddd.getPropertyFilePath(), ddrContext.getPropertyFileRootDirectory(), "ccsjrxml/propertyFiles/");
                }
            }
            return DynDataUtil.readFile(ENUMFileReadingType.FILE, ddd.getPropertyFilePath(), ddrContext.getPropertyFileRootDirectory(), "ccsjrxml/propertyFiles/");
        }
        catch (Throwable t) {
            if (!withError) {
                return null;
            }
            throw new Error("Could not read Property file: " + (Object)((Object)ddd.getPropertyFileReadingType()) + ", " + ddd.getPropertyFilePath(), t);
        }
    }

    public static String readXmlFileOfDynDataDefinition(DynDataReaderContext ddrContext, DynDataDefinition ddd, boolean withError) {
        try {
            return DynDataUtil.readFile(ddd.getXmlFileReadingType(), ddd.getXmlFilePath(), ddrContext.getXmlFileRootDirectory(), "ccsjrxml/xmlFiles/");
        }
        catch (Throwable t) {
            if (!withError) {
                return null;
            }
            throw new Error("Could not read XML file: " + (Object)((Object)ddd.getXmlFileReadingType()) + ", " + ddd.getXmlFilePath(), t);
        }
    }

    public static void saveXmlFileOfDynDataDefinition(DynDataReaderContext ddrContext, DynDataDefinition ddd, String xml, boolean withError) {
        try {
            DynDataUtil.writeFile(ddd.getXmlFileReadingType(), ddd.getXmlFilePath(), ddrContext.getXmlFileRootDirectory(), "ccsjrxml/xmlFiles/", xml);
        }
        catch (Throwable t) {
            if (!withError) {
                return;
            }
            throw new Error("Could not write XML file: " + (Object)((Object)ddd.getXmlFileReadingType()) + ", " + ddd.getXmlFilePath(), t);
        }
    }

    public static void saveJsonFileOfDynDataDefinition(DynDataReaderContext ddrContext, DynDataDefinition ddd, String json, boolean withError) {
        try {
            DynDataUtil.writeFile(ddd.getJsonFileReadingType(), ddd.getJsonFilePath(), ddrContext.getJsonFileRootDirectory(), "ccsjrxml/jsonFiles/", json);
        }
        catch (Throwable t) {
            if (!withError) {
                return;
            }
            throw new Error("Could not write XML file: " + (Object)((Object)ddd.getXmlFileReadingType()) + ", " + ddd.getXmlFilePath(), t);
        }
    }

    public static void savePropertyFileOfDynDataDefinition(DynDataReaderContext ddrContext, DynDataDefinition ddd, String text, boolean withError) {
        if (ddd.getPropertyFileReadingType() != ENUMPropertyFileReadingType.FILE && ddd.getPropertyFileReadingType() != ENUMPropertyFileReadingType.STREAMSTORE) {
            throw new Error("Reading of text of property file is only supported with types: FILE, STREAMSTORE");
        }
        try {
            switch (ddd.getPropertyFileReadingType()) {
                case STREAMSTORE: {
                    DynDataUtil.writeFile(ENUMFileReadingType.STREAMSTORE, ddd.getPropertyFilePath(), ddrContext.getPropertyFileRootDirectory(), "ccsjrxml/propertyFiles/", text);
                }
            }
            DynDataUtil.writeFile(ENUMFileReadingType.FILE, ddd.getPropertyFilePath(), ddrContext.getPropertyFileRootDirectory(), "ccsjrxml/propertyFiles/", text);
        }
        catch (Throwable t) {
            if (!withError) {
                return;
            }
            throw new Error("Could not write Property file: " + (Object)((Object)ddd.getPropertyFileReadingType()) + ", " + ddd.getPropertyFilePath(), t);
        }
    }

    public static List<FilePathInfo> readAvailableXMLFiles(DynDataReaderContext ddrContext) {
        return DynDataUtil.readAvailableFiles(ddrContext.getXmlFileRootDirectory(), "ccsjrxml/xmlFiles/");
    }

    public static List<FilePathInfo> readAvailableJSONFiles(DynDataReaderContext ddrContext) {
        return DynDataUtil.readAvailableFiles(ddrContext.getJsonFileRootDirectory(), "ccsjrxml/jsonFiles/");
    }

    public static List<FilePathInfo> readAvailablePropertyFiles(DynDataReaderContext ddrContext) {
        return DynDataUtil.readAvailableFiles(ddrContext.getPropertyFileRootDirectory(), "ccsjrxml/propertyFiles/");
    }

    private static DynDataMap readRootObjectByInterface(DynDataReaderContext dddReaderContext, DynDataDefinition ddd) {
        try {
            String className = ddd.getClassName() + "_Creator";
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className, true, ClassLoaderBridge.findCurrentClassLoader());
            }
            catch (Throwable tt) {
                return null;
            }
            ICreatePreviewTestObject cpto = (ICreatePreviewTestObject)clazz.newInstance();
            Object rootBean = cpto.createObject();
            if (rootBean instanceof DynDataMap) {
                return (DynDataMap)rootBean;
            }
            if (rootBean instanceof Map) {
                return new DynDataReader(dddReaderContext).createDynDataMapFromMap(ddd, (Map)rootBean);
            }
            Map map = PojoManager.transferPojoIntoMap((Object)rootBean);
            return new DynDataReader(dddReaderContext).createDynDataMap(ddd, map);
        }
        catch (Throwable t) {
            throw new Error("Problem creating preview root object by query: " + ddd.getDofwQuery(), t);
        }
    }

    static String readFile(ENUMFileReadingType readingType, String filePath, String fileRootDirectory, String streamStoreRootPath) {
        String result = null;
        if (readingType == ENUMFileReadingType.RESOURCE) {
            result = new ClassloaderReader(true).readUTF8File(filePath, true);
        } else if (readingType == ENUMFileReadingType.STREAMSTORE) {
            String fileName = streamStoreRootPath + "/" + filePath;
            fileName = ValueManager.encodeIntoValidStreamStorePath((String)fileName, (boolean)false);
            result = StreamStore.getInstance().readUTF8(fileName, true);
        } else if (readingType == ENUMFileReadingType.FILE) {
            String fileName = fileRootDirectory + "/" + filePath;
            fileName = ValueManager.encodeIntoValidFileName((String)fileName, (boolean)false);
            result = FileManager.readUTF8File((String)fileName, (boolean)true);
        } else {
            throw new Error("Unknown reading type: " + (Object)((Object)readingType));
        }
        return result;
    }

    private static void writeFile(ENUMFileReadingType readingType, String filePath, String fileRootDirectory, String streamStoreRootPath, String text) {
        if (readingType == ENUMFileReadingType.RESOURCE) {
            throw new Error("Writing not supported for readingType: " + (Object)((Object)readingType));
        }
        if (readingType == ENUMFileReadingType.STREAMSTORE) {
            String fileName = streamStoreRootPath + "/" + filePath;
            fileName = ValueManager.encodeIntoValidStreamStorePath((String)fileName, (boolean)false);
            StreamStore.getInstance().writeUTF8(fileName, text, true);
        } else if (readingType == ENUMFileReadingType.FILE) {
            String fileName = fileRootDirectory + "/" + filePath;
            fileName = ValueManager.encodeIntoValidFileName((String)fileName, (boolean)false);
            FileManager.ensureDirectoryForFileExists((String)fileName);
            FileManager.writeUTF8File((String)fileName, (String)text, (boolean)true);
        } else {
            throw new Error("Unknown reading type: " + (Object)((Object)readingType));
        }
    }

    private static List<DynDataAttribute> readAllPropertiyAttributesOfClass(String className) {
        ArrayList<DynDataAttribute> result = new ArrayList<DynDataAttribute>();
        try {
            Class<?> clazz = Class.forName(className, false, ClassLoaderBridge.findCurrentClassLoader());
            List piis = BeanIntrospector.readPropertiesAsList(clazz);
            for (BeanIntrospector.PropertyIntrospectionInfo pii : piis) {
                if (!ValueManager.checkIfSimpleDataType(pii.getGetter().getReturnType())) continue;
                DynDataAttribute dda = new DynDataAttribute();
                dda.setName(pii.getPropertyName());
                dda.setClassName(pii.getGetter().getReturnType().getName());
                dda.setKey(DynDataUtil.checkIfKey(clazz, pii.getPropertyName()));
                result.add(dda);
            }
        }
        catch (Throwable t) {
            AppLog.L.log(ICCEEConstants.LL_ERR, "Could not resolve properties of class: " + className);
        }
        return result;
    }

    private static String readCombinedMultiLanguagePropertyFileByInterface(DynDataDefinition ddd, DynDataReaderContext ddrContext) {
        StringBuffer sb = new StringBuffer();
        String contentString = PropertyAccess.instance().readPropertyFile(ddd.getPropertyFilePath());
        if (contentString != null && contentString.length() > 0) {
            sb.append(contentString);
        }
        String idWithLocale = ddd.getPropertyFilePath() + "_" + ddrContext.getLocale().getLanguage();
        String contentString2 = PropertyAccess.instance().readPropertyFile(idWithLocale);
        if (contentString2 != null && contentString2.length() > 0) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(contentString2);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    private static List<FilePathInfo> readAvailableFiles(String filePath, String streamStorePath) {
        ArrayList<FilePathInfo> result = new ArrayList<FilePathInfo>();
        List files = FileManager.getFilesOfDirectory((String)filePath);
        for (File file : files) {
            result.add(new FilePathInfo(ENUMFileReadingType.FILE, file.getName()));
        }
        IStreamStore streamStore = StreamStore.getInstance();
        List paths = streamStore.getContainedStreams(streamStorePath, true);
        for (String path : paths) {
            result.add(new FilePathInfo(ENUMFileReadingType.STREAMSTORE, path));
        }
        Collections.sort(result);
        return result;
    }

    public static String findDataContextName(DynDataReaderContext ddrContext, DynDataDefinition ddd) {
        if (ValueManager.isEmpty((String)ddd.getDataContextName())) {
            return ddrContext.getDbContextName();
        }
        return ddd.getDataContextName();
    }

    public static class FilePathInfo
    implements Comparable<FilePathInfo> {
        ENUMFileReadingType i_readingType;
        String i_filePath;

        public FilePathInfo(ENUMFileReadingType readingType, String filePath) {
            this.i_readingType = readingType;
            this.i_filePath = filePath;
        }

        public static FilePathInfo fromIdString(String ids) {
            if (ids == null) {
                return null;
            }
            int index = ids.indexOf(":");
            ENUMFileReadingType rt = ENUMFileReadingType.valueOf(ids.substring(0, index));
            String fp = ids.substring(index + 1);
            return new FilePathInfo(rt, fp);
        }

        public ENUMFileReadingType getReadingType() {
            return this.i_readingType;
        }

        public String getFilePath() {
            return this.i_filePath;
        }

        @Override
        public int compareTo(FilePathInfo o) {
            if (this.i_readingType != o.i_readingType) {
                return -1 * this.i_readingType.toString().compareTo(o.i_readingType.toString());
            }
            return this.i_filePath.toString().compareTo(o.i_filePath.toString());
        }

        public String toIdString() {
            return this.i_readingType.toString() + ":" + this.i_filePath;
        }
    }
}

