/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.facade.tools;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import java.util.Set;
import org.eclnt.ccee.facade.FacadeClient;
import org.eclnt.util.file.FileManager;

public class CreateFacadeStub {
    static final String TAB = "    ";
    static final String TABTAB = "        ";
    String m_srcDirectory;
    String m_stubClassName;
    Class<?> m_facadeClass;
    StringBuffer m_code = new StringBuffer();

    public CreateFacadeStub(String srcDirectory, String stubClassName, Class<?> facadeClass) {
        this.m_srcDirectory = srcDirectory;
        this.m_stubClassName = stubClassName;
        this.m_facadeClass = facadeClass;
    }

    public void createStub() {
        this.createStubCode();
        this.writeStubCode();
    }

    private void writeStubCode() {
        String fileName = this.m_srcDirectory + "/" + this.m_stubClassName.replace('.', '/') + ".java";
        FileManager.ensureDirectoryForFileExists((String)fileName);
        FileManager.ensureFileIsWriteable((String)fileName, (boolean)false);
        FileManager.writeUTF8File((String)fileName, (String)this.m_code.toString(), (boolean)true);
    }

    private void createStubCode() {
        Set<Method> ms = this.findPublicMethods();
        this.createPackage();
        this.createImportPackages();
        this.createClassCodeBegin();
        this.createMembers();
        this.createConstructor();
        for (Method m : ms) {
            this.createMethodCode(m);
        }
        this.createClassCodeEnd();
        System.out.println(this.m_code);
    }

    private void createConstructor() {
        this.m_code.append("    public " + this.findClassOfStubClass() + "(IFacadeTransfer transfer)\n");
        this.m_code.append("    {\n");
        this.m_code.append("        m_transfer = transfer;\n");
        this.m_code.append("    }\n");
        this.m_code.append("\n");
    }

    private void createMembers() {
        this.m_code.append("    IFacadeTransfer m_transfer;\n");
        this.m_code.append("\n");
    }

    private void createPackage() {
        this.m_code.append("package " + this.findPackageOfStubClass() + ";\n");
        this.m_code.append("\n");
    }

    private void createImportPackages() {
        this.m_code.append("import java.io.Serializable;\n");
        this.m_code.append("import " + FacadeClient.class.getPackage().getName() + ".*;\n");
        this.m_code.append("\n");
    }

    private void createClassCodeEnd() {
        this.m_code.append("}\n");
    }

    private void createClassCodeBegin() {
        this.m_code.append("public class " + this.findClassOfStubClass() + "\n");
        this.m_code.append("{\n");
    }

    private String findClassOfStubClass() {
        int lastIndex = this.m_stubClassName.lastIndexOf(".");
        if (lastIndex < 0) {
            throw new Error("Stub class name must reside in package: " + this.m_stubClassName);
        }
        return this.m_stubClassName.substring(lastIndex + 1);
    }

    private String findPackageOfStubClass() {
        int lastIndex = this.m_stubClassName.lastIndexOf(".");
        if (lastIndex < 0) {
            throw new Error("Stub class name must reside in package: " + this.m_stubClassName);
        }
        return this.m_stubClassName.substring(0, lastIndex);
    }

    private void createMethodCode(Method m) {
        Class<?> returnType = m.getReturnType();
        Parameter[] parameters = m.getParameters();
        StringBuffer sb = new StringBuffer();
        if (this.findClassNameForType(returnType, m.getGenericReturnType()).contains("<")) {
            sb.append("    @SuppressWarnings(\"unchecked\")\n");
        }
        sb.append("    public ");
        if (returnType == null) {
            sb.append("void ");
        } else {
            sb.append(this.findClassNameForType(returnType, m.getGenericReturnType()));
        }
        sb.append(" " + m.getName());
        sb.append("(");
        int counter = 0;
        for (Parameter parameter : parameters) {
            if (counter > 0) {
                sb.append(",");
            }
            sb.append(this.findClassNameForType(parameter.getType(), parameter.getParameterizedType()));
            sb.append(" ");
            sb.append(parameter.getName());
            ++counter;
        }
        sb.append(")\n");
        if (m.getExceptionTypes() != null && m.getExceptionTypes().length > 0) {
            sb.append("        throws ");
            counter = 0;
            for (AnnotatedElement annotatedElement : m.getExceptionTypes()) {
                if (counter > 0) {
                    sb.append(",");
                }
                sb.append(((Class)annotatedElement).getName());
                ++counter;
            }
            sb.append("\n");
        }
        sb.append("    {\n");
        sb.append(this.createMethodBody(m));
        sb.append("    }\n");
        sb.append("\n");
        this.m_code.append(sb.toString());
    }

    private String createMethodBody(Method m) {
        int counter;
        StringBuffer sb = new StringBuffer();
        sb.append("        try\n");
        sb.append("        {\n");
        sb.append("            FacadeClient fc = new FacadeClient(m_transfer);\n");
        if (m.getReturnType() == null || m.getReturnType().getName().equals("void")) {
            sb.append("            fc.callFacadeMethod\n");
        } else {
            sb.append("            return (" + this.findClassNameForType(m.getReturnType(), m.getGenericReturnType()) + ")fc.callFacadeMethod\n");
        }
        sb.append("            (\n");
        sb.append("                \"" + this.m_facadeClass.getName() + "\",\n");
        sb.append("                \"" + m.getName() + "\",\n");
        Parameter[] parameters = m.getParameters();
        if (parameters == null || parameters.length == 0) {
            sb.append("                null,\n");
        } else {
            sb.append("                new Class[] {");
            counter = 0;
            for (Parameter parameter : parameters) {
                if (counter > 0) {
                    sb.append(",");
                }
                sb.append(parameter.getType().getName() + ".class");
            }
            sb.append("},\n");
        }
        if (parameters == null || parameters.length == 0) {
            sb.append("                null\n");
        } else {
            sb.append("                new Serializable[] {");
            counter = 0;
            for (Parameter parameter : parameters) {
                if (counter > 0) {
                    sb.append(",");
                }
                sb.append(parameter.getName());
            }
            sb.append("}\n");
        }
        sb.append("            );\n");
        sb.append("        }\n");
        if (m.getExceptionTypes() != null && m.getExceptionTypes().length > 0) {
            counter = 0;
            for (AnnotatedElement annotatedElement : m.getExceptionTypes()) {
                sb.append("        catch (" + ((Class)annotatedElement).getName() + " exc" + counter + ") { throw exc" + counter + "; }\n");
                ++counter;
            }
        }
        sb.append("        catch (Error err) { throw err; }\n");
        sb.append("        catch (RuntimeException rte) { throw rte; }\n");
        sb.append("        catch (Throwable thr) { throw new Error(thr); }\n");
        return sb.toString();
    }

    private String findClassNameForType(Class clazz, Type type) {
        StringBuffer sb = new StringBuffer();
        sb.append(clazz.getName());
        TypeVariable<Class<T>>[] tvs = clazz.getTypeParameters();
        if (tvs != null && tvs.length > 0) {
            Type[] tas;
            sb.append("<");
            ParameterizedType ptype = (ParameterizedType)type;
            for (Type ta : tas = ptype.getActualTypeArguments()) {
                sb.append(ta.getTypeName());
            }
            sb.append(">");
        }
        return sb.toString();
    }

    private Set<Method> findPublicMethods() {
        Method[] ms;
        HashSet<Method> result = new HashSet<Method>();
        for (Method m : ms = this.m_facadeClass.getMethods()) {
            if (!Modifier.isStatic(m.getModifiers())) continue;
            result.add(m);
        }
        return result;
    }
}

