/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import java.util.Map;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.file.StreamUtil;
import org.eclnt.util.valuemgmt.ValueManager;

public class HttpDataTransfer {
    private static HttpDataTransfer s_instance = new HttpDataTransfer();

    public static HttpDataTransfer instance() {
        return s_instance;
    }

    public static void initialize(HttpDataTransfer instance) {
        s_instance = instance;
    }

    public String readUrlContentAsUTF8String(String urlString, boolean withError) {
        return this.readUrlContentAsUTF8String(urlString, null, null, withError);
    }

    public String readUrlContentAsUTF8String(String urlString, String userName, String password, boolean withError) {
        try {
            byte[] bytes = this.readURLContent(urlString, userName, password, true);
            String result = new String(bytes, "UTF-8");
            return result;
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem reading from urlString: " + urlString);
            }
            return null;
        }
    }

    public byte[] readURLContent(String urlString, boolean withError) {
        return this.readURLContent(urlString, null, null, withError);
    }

    public byte[] readURLContent(String urlString, String userName, String password, boolean withError) {
        try {
            if (!urlString.startsWith("file:")) {
                return this.readURLContentHttp(urlString, userName, password);
            }
            return this.readURLContentFile(urlString);
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem reading data from URL: " + urlString, t);
            }
            return null;
        }
    }

    public String createHeaderBasicAuthentication(String userName, String password) {
        if (userName != null && password != null) {
            byte[] authEncBytes = Base64.getEncoder().encode((userName + ":" + password).getBytes());
            String authStringEnc = new String(authEncBytes);
            return "Basic " + authStringEnc;
        }
        return null;
    }

    public byte[] sendPost(String url, String body, Map<String, String> headers) {
        HttpURLConnection con = null;
        try {
            URL targetURL = new URL(url);
            con = (HttpURLConnection)targetURL.openConnection();
            String requestJson = body == null ? "" : body;
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            if (headers != null) {
                for (String headerKey : headers.keySet()) {
                    String headerValue = headers.get(headerKey);
                    con.setRequestProperty(headerKey, headerValue);
                }
            }
            if (body != null) {
                byte[] bodyBytes = body.getBytes(ValueManager.CHARSET_UTF8);
                ByteArrayInputStream bis = new ByteArrayInputStream(bodyBytes);
                StreamUtil.transferStreamContent((InputStream)bis, (OutputStream)con.getOutputStream());
            }
            InputStream is = con.getInputStream();
            byte[] result = StreamUtil.transferStreamContentIntoBytes((InputStream)is);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Problem processing: " + url, t);
        }
    }

    private byte[] readURLContentFile(String urlString) {
        String fileName = urlString.substring("file://".length());
        return FileManager.readFile((String)fileName, (boolean)true);
    }

    private byte[] readURLContentHttp(String urlString, String userName, String password) throws Exception {
        URL url = new URL(urlString);
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        if (userName != null && password != null) {
            conn.setRequestProperty("Authorization", this.createHeaderBasicAuthentication(userName, password));
        }
        InputStream is = conn.getInputStream();
        byte[] result = StreamUtil.transferStreamContentIntoBytes((InputStream)is);
        return result;
    }
}

