/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.image;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageShrinker {
    public static byte[] sizeImage(byte[] bytes, int width, int height, boolean keepRatio, boolean onlyShrkinking) {
        try {
            ImageIcon originalImage = new ImageIcon(bytes);
            boolean landscape = true;
            if (onlyShrkinking && originalImage.getIconWidth() <= width && originalImage.getIconHeight() <= height) {
                return bytes;
            }
            BufferedImage newImage = new BufferedImage(width, height, 2);
            Graphics g = newImage.getGraphics();
            int newX = 0;
            int newY = 0;
            int newWidth = width;
            int newHeight = height;
            if (keepRatio && (newY = height / 2 - (newHeight = Math.round((float)width / (float)originalImage.getIconWidth() * (float)originalImage.getIconHeight())) / 2) < 0) {
                newY = 0;
                newHeight = height;
                newWidth = Math.round((float)height / (float)originalImage.getIconHeight() * (float)originalImage.getIconWidth());
                newX = width / 2 - newWidth / 2;
            }
            g.drawImage(originalImage.getImage(), newX, newY, newWidth, newHeight, null);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)newImage, "png", bos);
            bos.close();
            return bos.toByteArray();
        }
        catch (Throwable t) {
            throw new Error("Error occurred when shrinking", t);
        }
    }
}

