/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.pdf;

import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.PageRanges;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;
import org.eclnt.ccee.pdf.PDFPrintConfig;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.log.CLog;

public class PDFPrint {
    public static void testPrint() {
        byte[] pdfBytes = PDFPrint.readTestPdfBytes();
        PDFPrint.print(pdfBytes);
    }

    public static void print(byte[] pdfBytes) {
        PDFPrint.print(pdfBytes, null);
    }

    public static void print(byte[] pdfBytes, PDFPrintConfig config) {
        ByteArrayInputStream bis = new ByteArrayInputStream(pdfBytes);
        PDFPrint.printExecute(bis, config);
    }

    public static void print(InputStream pdfBytes, PDFPrintConfig config) {
        PDFPrint.printExecute(pdfBytes, config);
    }

    private static byte[] readTestPdfBytes() {
        String fileName = PDFPrint.class.getPackage().getName().replace(".", "/") + "/testpdf.pdf";
        byte[] pdfBytes = new ClassloaderReader(true).readFile(fileName, true);
        return pdfBytes;
    }

    private static void printExecute(InputStream pdfBytes, PDFPrintConfig config) {
        try {
            PDDocument pdd = PDDocument.load((InputStream)pdfBytes);
            PrinterJob job = PrinterJob.getPrinterJob();
            PrintService[] pservices = PrintServiceLookup.lookupPrintServices(null, null);
            HashPrintRequestAttributeSet prAtts = null;
            if (config != null) {
                if (config.getPrinterName() != null) {
                    PrintService myService = null;
                    for (PrintService pservice : pservices) {
                        if (!pservice.getName().equals(config.getPrinterName())) continue;
                        myService = pservice;
                        break;
                    }
                    if (myService == null) {
                        throw new Exception("Printer name not available: " + config.getPrinterName());
                    }
                    job.setPrintService(myService);
                }
                if (config.getFromPage() != null) {
                    int pageRangeStart;
                    if (prAtts == null) {
                        prAtts = new HashPrintRequestAttributeSet();
                    }
                    int pageRangeEnd = pageRangeStart = config.getFromPage().intValue();
                    if (config.getToPage() != null) {
                        pageRangeEnd = config.getToPage();
                    }
                    if (pageRangeEnd < pageRangeStart) {
                        throw new Exception("Incorrect page range: from " + pageRangeStart + ", to " + pageRangeEnd);
                    }
                    prAtts.add(new PageRanges(pageRangeStart, pageRangeEnd));
                }
            }
            job.setPageable((Pageable)new PDFPageable(pdd));
            if (prAtts == null) {
                job.print();
            } else {
                job.print(prAtts);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem occurred when printing to: " + config);
            throw new Error("Problem occurred when printing to: " + config, t);
        }
    }
}

