/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.prompting;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.markdown.commonmark.MarkdownTextConverter;
import org.eclnt.ccee.prompting.IPrompting;
import org.eclnt.ccee.prompting.IPromptingListener;
import org.eclnt.ccee.prompting.PromptingMessage;

public class PromptingBase
implements IPrompting {
    protected Set<IPromptingListener> m_listners = new HashSet<IPromptingListener>();
    StringBuffer m_currentResponseAsMarkdown = new StringBuffer();
    boolean m_waitingForResponseStart = false;
    boolean m_waitingForResponseEnd = false;
    List<PromptingMessage> m_requestMessages = new ArrayList<PromptingMessage>();
    MyRequestThread m_currentRequestThread = null;

    @Override
    public void addMessage(PromptingMessage message) {
        this.m_requestMessages.add(message);
    }

    @Override
    public final void startNewMessage(String text, boolean synchronous) {
        this.prepareNewMessage(text);
        this.m_waitingForResponseStart = true;
        this.m_currentResponseAsMarkdown = new StringBuffer();
        this.m_requestMessages.add(new PromptingMessage("user", text));
        if (synchronous) {
            this.startNewMessageExecute(this.m_requestMessages);
        } else {
            this.m_currentRequestThread = new MyRequestThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        PromptingBase.this.startNewMessageExecute(PromptingBase.this.m_requestMessages);
                    }
                    catch (Throwable t) {
                        if (t instanceof ErrorRequestCancelled) {
                            AppLog.L.log(AppLog.LL_INF, "Request was cancelled by user.");
                        }
                    }
                    finally {
                        PromptingBase.this.processResponseCompleted();
                    }
                }
            });
            this.m_currentRequestThread.start();
        }
    }

    public void prepareNewMessage(String text) {
    }

    @Override
    public void cancelCurrentRequest() {
        this.m_currentRequestThread.setCancelled(true);
    }

    @Override
    public void addPromptingListener(IPromptingListener listener) {
        this.m_listners.add(listener);
    }

    @Override
    public void removePromptingListener(IPromptingListener listener) {
        this.m_listners.remove(listener);
    }

    protected void startNewMessageExecute(List<PromptingMessage> messages) {
        if (this.m_currentRequestThread != null && this.m_currentRequestThread.getCancelled()) {
            throw new ErrorRequestCancelled();
        }
    }

    protected void processResponseMarkdownFragmentReceived(String markdown) {
        if (this.m_currentRequestThread != null && this.m_currentRequestThread.getCancelled()) {
            throw new ErrorRequestCancelled();
        }
        if (this.m_waitingForResponseStart) {
            for (IPromptingListener l : this.m_listners) {
                l.onReponseStarted();
            }
        }
        if (markdown != null && markdown.length() > 0) {
            this.m_currentResponseAsMarkdown.append(markdown);
            this.informListenersAboutResponseUpdate();
        }
        this.m_waitingForResponseStart = false;
        this.m_waitingForResponseEnd = true;
    }

    private void informListenersAboutResponseUpdate() {
        String html = MarkdownTextConverter.instance().convertMarkdownToHtml(this.m_currentResponseAsMarkdown.toString());
        for (IPromptingListener l : this.m_listners) {
            l.onReponseUpdated(html);
        }
    }

    protected void processResponseCompleted() {
        this.m_currentRequestThread = null;
        if (this.m_waitingForResponseEnd) {
            for (IPromptingListener l : this.m_listners) {
                l.onResponseCompleted();
            }
        }
        this.m_waitingForResponseStart = false;
        this.m_waitingForResponseEnd = false;
    }

    public class ErrorRequestCancelled
    extends RuntimeException {
    }

    public class MyRequestThread
    extends Thread {
        boolean i_cancelled;

        public MyRequestThread(Runnable target) {
            super(target);
            this.i_cancelled = false;
        }

        public void setCancelled(boolean cancelled) {
            this.i_cancelled = cancelled;
        }

        public boolean getCancelled() {
            return this.i_cancelled;
        }
    }
}

