/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.quartz.logic;

import java.util.Date;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.bridges.ClassLoaderBridge;
import org.eclnt.ccee.db.DBAction;
import org.eclnt.ccee.db.dofw.DOFWSql;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.quartz.data.DOJobExecution;
import org.eclnt.ccee.quartz.data.DOJobExecutionProtocol;
import org.eclnt.ccee.quartz.logic.CCEEJobExecutionContext;
import org.eclnt.ccee.quartz.logic.ICCEEJob;
import org.eclnt.ccee.quartz.logic.IJobConstants;
import org.eclnt.ccee.quartz.logic.QuartzSchedulerManager;
import org.eclnt.jsfserver.util.useraccess.DefaultTenantAccess;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class QuartzJobAdapter
implements Job,
ICCEEConstants,
IJobConstants {
    String m_jobId;
    String m_tenant;
    String m_className;
    String m_parameters;

    public final void execute(JobExecutionContext jec) throws JobExecutionException {
        this.m_jobId = (String)jec.getJobDetail().getJobDataMap().get((Object)"id");
        this.m_tenant = (String)jec.getJobDetail().getJobDataMap().get((Object)"tenant");
        this.m_className = (String)jec.getJobDetail().getJobDataMap().get((Object)"className");
        this.m_parameters = (String)jec.getJobDetail().getJobDataMap().get((Object)"parameters");
        AppLog.L.log(LL_INF, "Now executing Job: " + this.m_jobId + "/" + this.m_tenant + "/" + this.m_className + "/" + this.m_parameters);
        QuartzSchedulerManager schedulerManager = (QuartzSchedulerManager)jec.getJobDetail().getJobDataMap().get((Object)"schedulerManager");
        if (!schedulerManager.checkIfActive()) {
            return;
        }
        DefaultTenantAccess.associateTenantWithCurrentThread((String)this.m_tenant);
        final DOJobExecution jobExecution = new DOJobExecution();
        jobExecution.setTenant(this.m_tenant);
        jobExecution.setId(UniqueIdCreator.createUUID());
        jobExecution.setJobId(this.m_jobId);
        jobExecution.setJobClassName(this.m_className);
        jobExecution.setJobParameters(this.m_parameters);
        jobExecution.setJobStarted(new Date());
        final DOJobExecutionProtocol jobExecutionProtocol = new DOJobExecutionProtocol();
        jobExecutionProtocol.setTenant(this.m_tenant);
        jobExecutionProtocol.setId(jobExecution.getId());
        final CCEEJobExecutionContext jobExecutionContext = new CCEEJobExecutionContext(this.m_tenant);
        try {
            jobExecution.setStatus("STARTED");
            DOFWSql.saveObject(jobExecution);
            new DBAction(){

                @Override
                protected void run() throws Exception {
                    QuartzJobAdapter.executeJob(jobExecution, jobExecutionContext);
                    jobExecution.setStatus("ENDED");
                    jobExecution.setJobEnded(new Date());
                    DOFWSql.saveObject(jobExecution);
                    jobExecutionProtocol.setProtocol(jobExecutionContext.getProtocol());
                    DOFWSql.saveObject(jobExecutionProtocol);
                }
            };
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Problem when executing job instance: " + this.m_jobId, t);
            try {
                jobExecution.setStatus("ERROR");
                jobExecution.setJobEnded(new Date());
                DOFWSql.saveObject(jobExecution);
                jobExecutionProtocol.setProtocol(jobExecutionContext.getProtocol());
                DOFWSql.saveObject(jobExecutionProtocol);
            }
            catch (Throwable tt) {
                AppLog.L.log(LL_ERR, "Problem when saving failed job instance: " + this.m_jobId, t);
            }
        }
        DefaultTenantAccess.clearTenantWithCurrentThread();
    }

    private static void executeJob(DOJobExecution jobExecution, CCEEJobExecutionContext jobExecutionContext) throws Exception {
        Class<?> cl = Class.forName(jobExecution.getJobClassName(), true, ClassLoaderBridge.findCurrentClassLoader());
        ICCEEJob jobInstance = (ICCEEJob)cl.newInstance();
        jobInstance.executeJob(jobExecution.getJobParameters(), jobExecutionContext);
    }
}

