/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.runtimeexec;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.util.java.OSUtil;

public class RuntimeExecUtil {
    public static void exec(String[] fileNamesAndParameters, String[] envParameters, String runtimeDirectory, IConsoleListener consoleListener) {
        try {
            if (fileNamesAndParameters == null) {
                throw new Error("fileNamesAndParameters not passed");
            }
            if (runtimeDirectory == null) {
                throw new Error("runtimeDirectory not passed");
            }
            File fileDir = new File(runtimeDirectory);
            Process p = Runtime.getRuntime().exec(fileNamesAndParameters, envParameters, fileDir);
            RuntimeExecUtil.delegateProcessOutputToConsoleListener(p, consoleListener);
        }
        catch (Throwable t) {
            throw new Error("Problems when executing script: " + fileNamesAndParameters + ", " + runtimeDirectory, t);
        }
    }

    public static void execScript(String[] fileNamesAndParameters, String[] envParameters, String runtimeDirectory, IConsoleListener consoleListener) {
        try {
            String[] updatedFNAPs;
            if (fileNamesAndParameters == null) {
                throw new Error("fileNamesAnbParameters not passed");
            }
            if (runtimeDirectory == null) {
                throw new Error("runtimeDirectory not passed");
            }
            if (OSUtil.isWindows()) {
                updatedFNAPs = new String[fileNamesAndParameters.length + 3];
                updatedFNAPs[0] = "cmd";
                updatedFNAPs[1] = "/c";
                updatedFNAPs[2] = "call";
                for (int i = 0; i < fileNamesAndParameters.length; ++i) {
                    updatedFNAPs[i + 3] = fileNamesAndParameters[i];
                }
            } else {
                updatedFNAPs = fileNamesAndParameters;
            }
            File fileDir = new File(runtimeDirectory);
            Process p = Runtime.getRuntime().exec(updatedFNAPs, envParameters, fileDir);
            RuntimeExecUtil.delegateProcessOutputToConsoleListener(p, consoleListener);
        }
        catch (Throwable t) {
            throw new Error("Problems when executing script: " + fileNamesAndParameters + ", " + runtimeDirectory, t);
        }
    }

    private static void delegateProcessOutputToConsoleListener(Process p, final IConsoleListener consoleListener) throws InterruptedException {
        InputStream[] iss = new InputStream[]{p.getInputStream(), p.getErrorStream()};
        Thread[] threads = new Thread[iss.length];
        int counter = 0;
        for (final InputStream is : iss) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            consoleListener.reactOnConsoleLine(line);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            threads[counter] = consoleListener.createConsoleListenerThread(r);
            ++counter;
        }
        for (Thread t : threads) {
            t.start();
        }
        int exitCode = p.waitFor();
        AppLog.L.log(AppLog.LL_INF, "Process exited with code: " + exitCode);
        for (Thread t : threads) {
            t.join();
        }
    }

    public static interface IConsoleListener {
        public Thread createConsoleListenerThread(Runnable var1);

        public void reactOnConsoleLine(String var1);
    }
}

