/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.usagevariants;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclnt.ccee.usagevariants.IVariantPersistenceWithGlobalUsers;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.util.valuemgmt.ValueManager;

public class VariantPersistenceStreamStore
implements IVariantPersistenceWithGlobalUsers {
    static final String PREFIX_DATA = "/ccvariants/data/";
    static final String PREFIX_DEFAULTIDS = "/ccvariants/defaultids/";
    static final String PREFIX_ADMINIDS = "/ccvariants/adminids/";
    static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");

    @Override
    public String readDefaultVariantId(String userId, String serviceType, String serviceId) {
        String key = PREFIX_DEFAULTIDS + serviceType + "/" + serviceId + "/" + userId;
        return StreamStore.getInstance().readUTF8(key, false);
    }

    @Override
    public void saveDefaultVariantId(String userId, String serviceType, String serviceId, String variantId) {
        String key = PREFIX_DEFAULTIDS + serviceType + "/" + serviceId + "/" + userId;
        if (!ValueManager.isEmpty((String)variantId)) {
            StreamStore.getInstance().writeUTF8(key, variantId, true);
        } else {
            StreamStore.getInstance().removeStream(key, false);
        }
    }

    @Override
    public String readVariant(String userId, String serviceType, String serviceId, String variantId) {
        String key = this.buildKey(userId, serviceType, serviceId, variantId);
        return StreamStore.getInstance().readUTF8(key, false);
    }

    @Override
    public void saveVariant(String userId, String serviceType, String serviceId, String variantId, String variantData) {
        String key = this.buildKey(userId, serviceType, serviceId, variantId);
        StreamStore.getInstance().writeUTF8(key, variantData, true);
    }

    @Override
    public void removeVariant(String userId, String serviceType, String serviceId, String variantId) {
        String key = this.buildKey(userId, serviceType, serviceId, variantId);
        StreamStore.getInstance().removeStream(key, true);
    }

    @Override
    public List<String> queryVariantIds(String userId, String serviceType, String serviceId) {
        String partialKey = PREFIX_DATA + serviceType + "/" + serviceId + "/" + userId + "/";
        ArrayList l = StreamStore.getInstance().getContainedStreams(partialKey, false);
        if (l == null) {
            l = new ArrayList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < l.size(); ++i) {
            try {
                String fileName = (String)l.get(i);
                result.add(this.decodeVariantIdFromFileName(fileName));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Collections.sort(result);
        return result;
    }

    private String buildKey(String userId, String serviceType, String serviceId, String variantId) {
        String fileName = this.encodeVariantIdToFileName(variantId);
        return PREFIX_DATA + serviceType + "/" + serviceId + "/" + userId + "/" + fileName;
    }

    private String encodeVariantIdToFileName(String variantId) {
        if (variantId == null) {
            return null;
        }
        return ValueManager.encodeHexString((byte[])variantId.getBytes(CHARSET_UTF8));
    }

    private String decodeVariantIdFromFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        byte[] bs = ValueManager.decodeHexString((String)fileName);
        return new String(bs, CHARSET_UTF8);
    }

    @Override
    public List<String> queryParentUserIds(String userId) {
        return this.readGlobalUserIds();
    }

    @Override
    public void saveGlobalUserId(String userId) {
        if (userId == null) {
            return;
        }
        List<String> globalUserIds = this.readGlobalUserIds();
        if (!globalUserIds.contains(userId)) {
            globalUserIds.add(userId);
            String s = ValueManager.encodeCSV(globalUserIds);
            String key = "/ccvariants/adminids/cc_globalUserIds";
            StreamStore.getInstance().writeUTF8(key, s, true);
        }
    }

    public void removeGlobalUserId(String userId) {
        if (userId == null) {
            return;
        }
        List<String> globalUserIds = this.readGlobalUserIds();
        if (globalUserIds.contains(userId)) {
            globalUserIds.remove(userId);
            String s = ValueManager.encodeCSV(globalUserIds);
            String key = "/ccvariants/adminids/cc_globalUserIds";
            StreamStore.getInstance().writeUTF8(key, s, true);
        }
    }

    private List<String> readGlobalUserIds() {
        String[] glUserIds;
        String key = "/ccvariants/adminids/cc_globalUserIds";
        String s = StreamStore.getInstance().readUTF8(key, false);
        if (s == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String glUserId : glUserIds = ValueManager.decodeCSV((String)s)) {
            if ((glUserId = glUserId.trim()).length() <= 0) continue;
            result.add(glUserId);
        }
        return result;
    }
}

