/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.config;

import java.io.StringReader;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.bridges.ClassLoaderBridge;
import org.eclnt.ccee.config.IConfigProvider;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.util.ResourceBundleUtil;
import org.eclnt.jsfserver.util.useraccess.TenantAccessMgr;
import org.eclnt.util.file.ConfigFileReader;

public class Config
implements ICCEEConstants {
    public static final String CONFIG_db_connectionproviderclassname = "db_connectionproviderclassname";
    public static final String CONFIG_db_connectionpasswordproviderclassname = "db_connectionpasswordproviderclassname";
    public static final String CONFIG_db_driver = "db_driver";
    public static final String CONFIG_db_url = "db_url";
    public static final String CONFIG_db_username = "db_username";
    public static final String CONFIG_db_password = "db_password";
    public static final String CONFIG_db_schema = "db_schema";
    public static final String CONFIG_db_explicitSchema = "db_explicitSchema";
    public static final String CONFIG_db_withpooling = "db_withpooling";
    public static final String CONFIG_db_sqldialect = "db_sqldialect";
    public static final String CONFIG_db_autotrim = "db_autotrim";
    public static final String CONFIG_db_datasource = "db_datasource";
    public static final String CONFIG_db_traceclassname = "db_traceclassname";
    public static final String CONFIG_db_connectionavailableatthread = "db_connectionavailableatthread";
    public static final String CONFIG_db_changelogwriterclassname = "db_changelogwriterclassname";
    public static final String CONFIG_db_valueloggingactive = "db_valueloggingactive";
    public static final String CONFIG_config_configproviderclassname = "config_configproviderclassname";
    public static final String CONFIG_config_cascading = "config_cascading";
    public static final String CONFIG_quartz_active = "quartz_active";
    public static final String CONFIG_quartz_autosetup = "quartz_autosetup";
    public static final String CONFIG_deepl_apikey = "deepl_apikey";
    public static final String CONFIG_openai_projectid = "openai_projectid";
    public static final String CONFIG_openai_apikey = "openai_apikey";
    public static final String CONFIG_openai_company = "openai_company";
    public static final String CONFIG_activemq_borkerURL = "activemq_brokerurl";
    public static final String CONFIG_activemq_username = "activemq_username";
    public static final String CONFIG_activemq_password = "activemq_password";
    static URLClassLoader s_externalClassLoader;
    static Map<String, ResourceBundle> s_configProperties;
    static boolean s_configCascading;
    static IConfigProvider s_configProvider;

    public static void initializeConfigProvider(IConfigProvider configProvider) {
        s_configProvider = configProvider;
    }

    public static boolean isCascading() {
        return s_configCascading;
    }

    public static String getConfigValue(String key) {
        return Config.getConfigValue("CCEE_DEFAULTCONTEXT", key);
    }

    public static String getConfigValue(String contextName, String key) {
        ResourceBundle r;
        String result = null;
        if (s_configProvider != null) {
            result = s_configProvider.getConfigValue(contextName, key);
        }
        if (result == null) {
            result = System.getenv(contextName + "_" + key);
        }
        if (result == null) {
            result = System.getProperty(contextName + "_" + key);
        }
        if (result == null && (result = ResourceBundleUtil.readValue(r = Config.readConfiguration(contextName), key)) == null && !"CCEE_DEFAULTCONTEXT".equals(contextName) && s_configCascading) {
            if (s_configProvider != null) {
                result = s_configProvider.getConfigValue("CCEE_DEFAULTCONTEXT", key);
            }
            if (result == null) {
                r = Config.readConfiguration("CCEE_DEFAULTCONTEXT");
                result = ResourceBundleUtil.readValue(r, key);
            }
        }
        if (result != null && result.contains("@TENANT@")) {
            String tenant = TenantAccessMgr.getCurrentTenant();
            result = result.replace("@TENANT@", tenant);
        }
        return result;
    }

    private static void intitializeConfigProvider(String configProviderClassName) {
        try {
            AppLog.L.log(LL_INF, "Initializing config provider: " + configProviderClassName);
            if (configProviderClassName == null) {
                s_configProvider = null;
            } else {
                ClassLoader cl = ClassLoaderBridge.findCurrentClassLoader();
                Class<?> c = Class.forName(configProviderClassName, true, cl);
                s_configProvider = (IConfigProvider)c.newInstance();
            }
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Problem when creating instance of config provider: " + configProviderClassName, t);
            throw new Error("Problem when creating instance of config provider: " + configProviderClassName, t);
        }
    }

    private static ResourceBundle readConfiguration(String contextName) {
        ResourceBundle r = s_configProperties.get(contextName);
        if (r != null) {
            return r;
        }
        try {
            String content;
            String configName = "ccee_config";
            if (!contextName.equals("CCEE_DEFAULTCONTEXT")) {
                configName = "ccee_config_" + contextName;
            }
            if ((content = ConfigFileReader.readConfigFile((String)(configName + ".properties"))) == null) {
                AppLog.L.log(LL_INF, "No content available when reading: " + configName + ".properties");
                content = "";
            }
            StringReader sr = new StringReader(content);
            PropertyResourceBundle prb = new PropertyResourceBundle(sr);
            sr.close();
            s_configProperties.put(contextName, prb);
            return prb;
        }
        catch (Throwable t) {
            try {
                AppLog.L.log(LL_INF, "Resource file for context name is not available: " + contextName + ", " + t.toString());
                ResourceBundle r2 = ResourceBundle.getBundle("org.eclnt.ccee.config.empty", Locale.getDefault(), Config.class.getClassLoader());
                s_configProperties.put(contextName, r2);
                return r2;
            }
            catch (Throwable tt) {
                throw new Error("Problem accessing default empty resource bundle org.eclnt.ccee.config.empty", tt);
            }
        }
    }

    static {
        String configCascading;
        s_externalClassLoader = null;
        s_configProperties = new Hashtable<String, ResourceBundle>();
        s_configCascading = false;
        s_configProvider = null;
        Config.readConfiguration("CCEE_DEFAULTCONTEXT");
        String configProviderClassName = Config.getConfigValue(CONFIG_config_configproviderclassname);
        if (configProviderClassName != null) {
            Config.intitializeConfigProvider(configProviderClassName);
        }
        if ("true".equals(configCascading = Config.getConfigValue(CONFIG_config_cascading))) {
            s_configCascading = true;
        }
    }
}

