/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.config.Config;
import org.eclnt.ccee.db.IDBConnectionAvailableAtThread;
import org.eclnt.ccee.db.IDBConnectionPasswordProvider;
import org.eclnt.ccee.db.IDBConnectionProvider;
import org.eclnt.ccee.db.IDBConnectionProvider_dbautotrim;
import org.eclnt.ccee.db.dofw.DBConnectionPasswordProviderManager;
import org.eclnt.ccee.db.dofw.DBConnectionPool;
import org.eclnt.ccee.db.dofw.DBConnectionProviderManager;
import org.eclnt.ccee.db.dofw.DOFWDialect;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.log.PLog;

public class DBAccess
implements ICCEEConstants {
    static final String TYPE_CREATECONNECTIONDURATION = "DOFWSql.createConnectionDuration";
    static final String TYPE_CREATECONNECTIONCOUNT = "DOFWSql.createConnectionCount";
    static Hashtable<Thread, ThreadContext> ss_threadConnections = new Hashtable();
    static Hashtable<Thread, ThreadContext> ss_threadIsolatedConnections = new Hashtable();
    static Hashtable<Thread, Boolean> ss_threadInIsolationMode = new Hashtable();
    static int s_connectionCounter = 0;
    static boolean s_usePooledConnectionByDefault = false;
    static IDBConnectionAvailableAtThread s_dbConnectionAvailableAtThread = null;
    static final Map<String, Boolean> s_autoTrimBuffer;

    public static void startIsolationMode() {
        Boolean b = ss_threadInIsolationMode.get(Thread.currentThread());
        if (Boolean.TRUE.equals(b)) {
            throw new Error("Isolation mode is already started. Nesting of isolation modes is not supported.");
        }
        ss_threadInIsolationMode.put(Thread.currentThread(), true);
    }

    public static void endIsolationMode() {
        ss_threadInIsolationMode.remove(Thread.currentThread());
    }

    public static void initDBConnectionAvailableAtThread(IDBConnectionAvailableAtThread dbcaat) {
        s_dbConnectionAvailableAtThread = dbcaat;
    }

    public static void initUsePooledConnectionByDefault(boolean value) {
        s_usePooledConnectionByDefault = value;
    }

    public static PickConnectionResult pickConnection(Object reference, String contextName) throws SQLException {
        PickConnectionResult result = new PickConnectionResult();
        ThreadContext tc = DBAccess.pickOrCreateThreadContext(reference, contextName);
        ThreadSubContext tsc = tc.i_subContexts.get(contextName);
        if (tc.i_creator == reference) {
            result.wasCreated = true;
        }
        result.connection = tsc.i_connection;
        result.explicitSchema = tsc.i_explicitSchema;
        result.autotrim = tsc.i_autotrim;
        return result;
    }

    public static int getCurrentNumberOfUserConnections() {
        return s_connectionCounter;
    }

    public static void addCommitRunnable(Runnable r) {
        try {
            ThreadContext tc = DBAccess.pickCurrentThreadContext(false);
            if (tc == null) {
                throw new Error("Thread context is no openend yet.");
            }
            tc.addCommitRunnable(r);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static void commitConnection(String contextName) {
        ThreadContext tc = DBAccess.pickCurrentThreadContext(true);
        ThreadSubContext tcs = tc.i_subContexts.get(contextName);
        if (tcs == null) {
            throw new Error("No sub context found with contextName: " + contextName);
        }
        tcs.i_commitRequired = true;
    }

    public static void rollbackConnection() throws SQLException {
        ThreadContext tc = DBAccess.s_threadConnections().get(Thread.currentThread());
        if (tc == null) {
            return;
        }
        for (ThreadSubContext tsc : tc.i_subContexts.values()) {
            if (!tsc.i_commitRequired) continue;
            try {
                AppLog.L.log(LL_INF, "DBAccess: Rolling back connection, contextName: " + tsc.i_contextName);
                tsc.i_connection.rollback();
            }
            catch (Throwable t) {
                AppLog.L.log(LL_ERR, "DBAccess: Problem when rolling back connection", t);
            }
        }
        tc.i_commitRunnables.clear();
    }

    public static void closeConnection(Object reference) throws SQLException {
        ThreadContext tc = DBAccess.pickCurrentThreadContext(false);
        if (tc == null) {
            return;
        }
        if (tc.i_creator != reference) {
            return;
        }
        try {
            for (ThreadSubContext tcs : tc.i_subContexts.values()) {
                if (!tcs.i_commitRequired) continue;
                try {
                    AppLog.L.log(LL_INF, "DBAccess: Committing connection, contextName: " + tcs.i_contextName);
                    tcs.i_connection.commit();
                }
                catch (Throwable t) {
                    AppLog.L.log(LL_ERR, "DBAccess: Problem when committing connection", t);
                    throw new Error(t);
                }
            }
            try {
                for (Runnable r : tc.i_commitRunnables) {
                    try {
                        r.run();
                    }
                    catch (Throwable t) {
                        AppLog.L.log(LL_ERR, "DBAccess: Problem when executing runnable which is part of commit processing", t);
                        AppLog.L.log(LL_ERR, "DBAccess: Processing is continued");
                    }
                }
            }
            catch (Throwable t) {
                AppLog.L.log(LL_ERR, "DBAccess: Problem when executing commit runnable", t);
            }
            DBAccess.s_threadConnections().remove(Thread.currentThread());
        }
        catch (Throwable t) {
            try {
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new Error("Problem during closeConnection", t);
            }
            catch (Throwable throwable) {
                DBAccess.s_threadConnections().remove(Thread.currentThread());
                for (ThreadSubContext tcs : tc.i_subContexts.values()) {
                    DBAccess.closeDBConnection(tcs.i_contextName, tcs.i_connection);
                }
                tc.i_commitRunnables.clear();
                tc.i_subContexts.clear();
                throw throwable;
            }
        }
        for (ThreadSubContext tcs : tc.i_subContexts.values()) {
            DBAccess.closeDBConnection(tcs.i_contextName, tcs.i_connection);
        }
        tc.i_commitRunnables.clear();
        tc.i_subContexts.clear();
    }

    public static void junit_clearThreadContext() {
        DBAccess.s_threadConnections().remove(Thread.currentThread());
    }

    private static void closeDBConnection(String contextName, Connection connection) {
        if (DBAccess.checkIfConnectionPoolActive()) {
            DBConnectionPool.addToPool(contextName, connection);
            DBAccess.updateConnectionCount(-1);
        } else {
            try {
                connection.close();
                DBAccess.updateConnectionCount(-1);
            }
            catch (Throwable t) {
                AppLog.L.log(LL_ERR, "Problem closing the database connection", t);
            }
        }
    }

    private static boolean checkIfConnectionPoolActive() {
        String configValue = Config.getConfigValue("db_withpooling");
        if ("true".equals(configValue)) {
            return true;
        }
        if ("false".equals(configValue)) {
            return false;
        }
        return s_usePooledConnectionByDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection createConnection(String contextName) throws SQLException {
        String password;
        String user;
        String url;
        String driver;
        long timeStampStart;
        block23: {
            IDBConnectionPasswordProvider cpp;
            timeStampStart = System.currentTimeMillis();
            AppLog.L.info("CONTEXTNAME-------------------: " + contextName);
            if (DBAccess.checkIfConnectionPoolActive()) {
                AppLog.L.info("db_withpooling................: true");
                Connection pooledConnection = DBConnectionPool.pickFromPool(contextName);
                if (pooledConnection != null) {
                    AppLog.L.info("Pooled connection was available.");
                    DBAccess.updateConnectionCount(1);
                    Connection connection = pooledConnection;
                    return connection;
                }
            }
            String connectionProviderClassName = Config.getConfigValue(contextName, "db_connectionproviderclassname");
            String connectionPasswordProviderClassName = Config.getConfigValue(contextName, "db_connectionpasswordproviderclassname");
            driver = Config.getConfigValue(contextName, "db_driver");
            url = Config.getConfigValue(contextName, "db_url");
            user = Config.getConfigValue(contextName, "db_username");
            String schema = Config.getConfigValue(contextName, "db_schema");
            String explicitSchema = Config.getConfigValue(contextName, "db_explicitSchema");
            String datasourceName = Config.getConfigValue(contextName, "db_datasource");
            password = Config.getConfigValue(contextName, "db_password");
            if (connectionPasswordProviderClassName != null && (cpp = DBConnectionPasswordProviderManager.findDBConnectionPasswordProvider(contextName)) != null) {
                password = cpp.getConnectionPassword(contextName);
            }
            if (datasourceName != null) {
                AppLog.L.info("db_datasource.................: " + datasourceName);
            } else if (connectionProviderClassName != null) {
                AppLog.L.info("db_connectionproviderclassname: " + connectionProviderClassName);
            } else {
                AppLog.L.info("db_driver.....................: " + driver);
                AppLog.L.info("db_url........................: " + url);
            }
            AppLog.L.info("db_explicitSchema.............: " + explicitSchema);
            String dialect = DOFWDialect.findSqlDialect(contextName);
            AppLog.L.info("dialect.......................: " + dialect);
            DOFWDialect.approveDialectIsOK(dialect);
            IDBConnectionProvider connectionProvider = DBConnectionProviderManager.findDBConnectionProvider(contextName);
            if (connectionProvider != null) {
                try {
                    Connection result = connectionProvider.createConnection(contextName);
                    if (result == null) {
                        throw new Error("Connection provider did not return a connection; connectionProvider: " + connectionProvider.getClass().getName());
                    }
                    result.setAutoCommit(false);
                    if (schema != null && schema.length() > 0) {
                        result.setSchema(schema);
                    }
                    DBAccess.updateConnectionCount(1);
                    Connection connection = result;
                    return connection;
                }
                catch (Throwable t) {
                    AppLog.L.log(LL_ERR, "Problem getting connection from connection provider " + connectionProviderClassName, t);
                    throw new Error(t);
                }
            }
            if (datasourceName == null) break block23;
            try {
                InitialContext ctx = new InitialContext();
                DataSource dataSource = (DataSource)ctx.lookup("java:comp/env/jdbc/" + datasourceName);
                Connection result = dataSource.getConnection();
                result.setAutoCommit(false);
                if (schema != null && schema.length() > 0) {
                    result.setSchema(schema);
                }
                DBAccess.updateConnectionCount(1);
                Connection connection = result;
                return connection;
            }
            catch (NamingException e) {
                throw new Error(e);
            }
        }
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
        Connection result = DriverManager.getConnection(url, user, password);
        result.setAutoCommit(false);
        result.setTransactionIsolation(2);
        DBAccess.updateConnectionCount(1);
        Connection connection = result;
        return connection;
        finally {
            long timeStampEnd = System.currentTimeMillis();
            PLog.accumulateNumberInCurrentRequest((String)TYPE_CREATECONNECTIONCOUNT, (long)1L);
            PLog.accumulateNumberInCurrentRequest((String)TYPE_CREATECONNECTIONDURATION, (long)(timeStampEnd - timeStampStart));
        }
    }

    private static synchronized void updateConnectionCount(int delta) {
        s_connectionCounter += delta;
        if (delta > 0) {
            AppLog.L.info("DBAccess: Connection created. Total number of connections: " + s_connectionCounter);
        } else {
            AppLog.L.info("DBAccess: Connection closed. Total number of connections: " + s_connectionCounter);
        }
    }

    private static ThreadContext pickCurrentThreadContext(boolean withError) {
        ThreadContext tc = DBAccess.s_threadConnections().get(Thread.currentThread());
        if (tc == null && withError) {
            throw new Error("No DBAccess information was applied to this thread.");
        }
        return tc;
    }

    private static Hashtable<Thread, ThreadContext> s_threadConnections() {
        Boolean isolateionMode = ss_threadInIsolationMode.get(Thread.currentThread());
        if (Boolean.TRUE.equals(isolateionMode)) {
            return ss_threadIsolatedConnections;
        }
        return ss_threadConnections;
    }

    private static ThreadContext pickOrCreateThreadContext(Object reference, String contextName) throws SQLException {
        ThreadSubContext tsc;
        ThreadContext tc = DBAccess.s_threadConnections().get(Thread.currentThread());
        if (tc == null) {
            tc = new ThreadContext();
            tc.i_creator = reference;
        }
        if ((tsc = tc.i_subContexts.get(contextName)) == null) {
            tsc = new ThreadSubContext();
            tsc.i_contextName = contextName;
            if (s_dbConnectionAvailableAtThread != null) {
                tsc.i_connection = s_dbConnectionAvailableAtThread.getConnectionAtCurrentThread(contextName);
                tc.i_creator = new Object();
            }
            if (tsc.i_connection == null) {
                tsc.i_connection = DBAccess.createConnection(contextName);
            }
            tsc.i_explicitSchema = DBAccess.findExplicitSchema(contextName);
            tsc.i_autotrim = DBAccess.findAutotrim(contextName);
            tc.i_subContexts.put(contextName, tsc);
        }
        DBAccess.s_threadConnections().put(Thread.currentThread(), tc);
        return tc;
    }

    private static String findExplicitSchema(String contextName) {
        String result = null;
        IDBConnectionProvider dbcp = DBConnectionProviderManager.findDBConnectionProvider(contextName);
        if (dbcp != null && (result = dbcp.getExplicitSchema(contextName)) != null) {
            return result;
        }
        return Config.getConfigValue(contextName, "db_explicitSchema");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean findAutotrim(String contextName) {
        Boolean result = s_autoTrimBuffer.get(contextName);
        if (result != null) {
            return result;
        }
        Map<String, Boolean> map = s_autoTrimBuffer;
        synchronized (map) {
            result = s_autoTrimBuffer.get(contextName);
            if (result != null) {
                return result;
            }
            IDBConnectionProvider dbcp = DBConnectionProviderManager.findDBConnectionProvider(contextName);
            if (dbcp != null && dbcp instanceof IDBConnectionProvider_dbautotrim) {
                result = ((IDBConnectionProvider_dbautotrim)dbcp).getDBAutotrim(contextName);
            }
            if (result == null) {
                String s = Config.getConfigValue(contextName, "db_autotrim");
                result = "true".equals(s) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            s_autoTrimBuffer.put(contextName, result);
            return result;
        }
    }

    static {
        String s = null;
        try {
            s = Config.getConfigValue("db_connectionavailableatthread");
            if (s != null) {
                Class c = CCClassResolver.resolveClass((String)s, (ENUMCallerType)ENUMCallerType.APPLICATIONFRAMEWORK);
                s_dbConnectionAvailableAtThread = (IDBConnectionAvailableAtThread)c.newInstance();
            }
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Problem during initialization: " + s, t);
            throw new Error("Problem during initialization: " + s, t);
        }
        s_autoTrimBuffer = new Hashtable<String, Boolean>();
    }

    public static class PickConnectionResult {
        Connection connection;
        boolean wasCreated = false;
        String explicitSchema = null;
        boolean autotrim = false;

        public Connection getConnection() {
            return this.connection;
        }

        public String getExplicitSchema() {
            return this.explicitSchema;
        }

        public boolean getAutotrim() {
            return this.autotrim;
        }
    }

    public static class ThreadContext {
        Object i_creator;
        List<Runnable> i_commitRunnables = new ArrayList<Runnable>();
        Map<String, ThreadSubContext> i_subContexts = new HashMap<String, ThreadSubContext>();

        public Object getCreator() {
            return this.i_creator;
        }

        public void addCommitRunnable(Runnable r) {
            this.i_commitRunnables.add(r);
        }
    }

    public static class ThreadSubContext {
        Connection i_connection;
        boolean i_commitRequired = false;
        String i_contextName;
        String i_explicitSchema = null;
        boolean i_autotrim = false;

        public Connection getConnection() {
            return this.i_connection;
        }

        public String getExplicitSchema() {
            return this.i_explicitSchema;
        }

        public boolean getAutotrim() {
            return this.i_autotrim;
        }
    }
}

