/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.StringTokenizer;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.db.DBAction;
import org.eclnt.ccee.db.dofw.DOFWDialect;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.valuemgmt.ValueManager;

public class DBCreateTables
implements ICCEEConstants {
    public static void main(String[] args) {
        try {
            new DBCreateTables().execute();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean execute() {
        return this.createTables();
    }

    public boolean createTables() {
        return this.createTables("CCEE_DEFAULTCONTEXT");
    }

    public boolean createTables(String contextName) {
        String resourceName = "ccee_dbcreatetables.sql";
        if (!contextName.equals("CCEE_DEFAULTCONTEXT")) {
            resourceName = "ccee_dbcreatetables_" + contextName + ".sql";
        }
        return this.createTablesByExplicitResourceFile(contextName, resourceName);
    }

    public boolean createTablesByExplicitResourceFile(String resourceName) {
        return this.createTablesByExplicitResourceFile("CCEE_DEFAULTCONTEXT", resourceName);
    }

    @Deprecated
    public boolean creatTablesByExplicitResourceFile(String resourceName) {
        return this.createTablesByExplicitResourceFile(resourceName);
    }

    public boolean createTablesByExplicitResourceFile(String contextName, String resourceName) {
        String allSql = new ClassloaderReader().readUTF8File(resourceName, true);
        return this.createTablesBySqlSequence(contextName, allSql);
    }

    @Deprecated
    public boolean creatTablesByExplicitResourceFile(String contextName, String resourceName) {
        return this.createTablesByExplicitResourceFile(contextName, resourceName);
    }

    public boolean createTablesBySqlSequence(String contextName, String allSql) {
        boolean result = true;
        allSql = this.removeComments(allSql);
        allSql = allSql.replace("/", ";");
        StringTokenizer st = new StringTokenizer(allSql, ";");
        while (st.hasMoreTokens()) {
            String sql = st.nextToken();
            try {
                sql = sql.trim();
                if (sql.length() == 0) continue;
                AppLog.L.log(LL_INF, "");
                AppLog.L.log(LL_INF, "*****************************************************");
                AppLog.L.log(LL_INF, "Execution of SQL: ");
                AppLog.L.log(LL_INF, "*****************************************************");
                this.executeStatement(contextName, sql);
                AppLog.L.log(LL_INF, "*****************************************************");
                AppLog.L.log(LL_INF, "SUCCESSFULLY EXECUTED.");
                AppLog.L.log(LL_INF, "*****************************************************");
            }
            catch (Throwable t) {
                SQLException sqlExc = null;
                if (t.getCause() instanceof SQLException) {
                    sqlExc = (SQLException)t.getCause();
                }
                if (sqlExc != null && DOFWDialect.checkIfSQLErrorDueToAlreadyExistingObject(sqlExc)) {
                    AppLog.L.log(LL_INF, "*****************************************************");
                    AppLog.L.log(LL_INF, "ALREADY EXISTS IN DATABASE");
                    AppLog.L.log(LL_INF, "*****************************************************");
                    continue;
                }
                AppLog.L.log(LL_INF, "*****************************************************");
                AppLog.L.log(LL_INF, "NOT EXECUTED DUE TO ERROR");
                this.logThrowableWithCauses(t);
                AppLog.L.log(LL_INF, "*****************************************************");
                result = false;
            }
        }
        return result;
    }

    protected String removeComments(String allSql) {
        if (allSql == null) {
            return null;
        }
        List lines = ValueManager.getLinesOfText((String)allSql);
        int linesSizeBefore = lines.size();
        for (int i = lines.size() - 1; i >= 0; --i) {
            String line = (String)lines.get(i);
            if (line.startsWith("#")) {
                lines.remove(i);
                continue;
            }
            if (!line.startsWith("--")) continue;
            lines.remove(i);
        }
        if (linesSizeBefore == lines.size()) {
            return allSql;
        }
        StringBuffer sb = new StringBuffer();
        for (String line : lines) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(line);
        }
        return sb.toString();
    }

    protected void logThrowableWithCauses(Throwable t) {
        String oneLine = t.toString();
        oneLine = oneLine.replace("\n", "");
        oneLine = oneLine.replace("\r", "");
        AppLog.L.log(LL_INF, oneLine);
        if (t.getCause() != null && t.getCause() != t) {
            this.logThrowableWithCauses(t.getCause());
        }
    }

    protected void executeStatement(String contextName, String sql) {
        final String sqlExecute = this.adaptCreateTablesStatement(contextName, sql);
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                PreparedStatement p = this.createStatement(sqlExecute);
                p.executeUpdate();
            }
        };
    }

    protected String adaptCreateTablesStatement(String contextName, String sql) {
        try {
            return DOFWDialect.adaptTableCreationStatement(contextName, sql);
        }
        catch (Throwable t) {
            AppLog.L.log(LL_INF, "Problem convering create table statement", t);
            return sql;
        }
    }
}

