/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.db.dofw.DOFWSql;

public class CACHESql
implements ICCEEConstants {
    static final Object NULL_OBJECT = new Object();
    Map<String, Object> m_cache = new HashMap<String, Object>();

    public <OBJTYPE> OBJTYPE queryOne(Class<OBJTYPE> clazz, Object ... colVals) {
        return this.queryOne("CCEE_DEFAULTCONTEXT", clazz, colVals);
    }

    public <OBJTYPE> OBJTYPE queryOne(String contextName, Class<OBJTYPE> clazz, Object ... colVals) {
        String keyStr = this.generateCacheKey("queryOne", contextName, clazz, colVals);
        Object obj = this.m_cache.get(keyStr);
        if (obj == NULL_OBJECT) {
            return null;
        }
        if (obj != null) {
            return (OBJTYPE)obj;
        }
        obj = DOFWSql.queryOne(contextName, clazz, colVals);
        if (obj != null) {
            this.m_cache.put(keyStr, obj);
        } else {
            this.m_cache.put(keyStr, NULL_OBJECT);
        }
        return (OBJTYPE)obj;
    }

    public <OBJTYPE> List<OBJTYPE> query(Class<OBJTYPE> clazz, Object ... colVals) {
        return this.query("CCEE_DEFAULTCONTEXT", clazz, colVals);
    }

    public <OBJTYPE> List<OBJTYPE> query(String contextName, Class<OBJTYPE> clazz, Object ... colVals) {
        String keyStr = this.generateCacheKey("query", contextName, clazz, colVals);
        List<OBJTYPE> obj = this.m_cache.get(keyStr);
        if (obj != null) {
            return obj;
        }
        obj = DOFWSql.query(contextName, clazz, colVals);
        this.m_cache.put(keyStr, obj);
        return obj;
    }

    public <OBJTYPE> List<OBJTYPE> queryTop(Class<OBJTYPE> clazz, int top, Object ... colVals) {
        return this.queryTop("CCEE_DEFAULTCONTEXT", clazz, top, colVals);
    }

    public <OBJTYPE> List<OBJTYPE> queryTop(String contextName, Class<OBJTYPE> clazz, int top, Object ... colVals) {
        String keyStr = this.generateCacheKey("queryTop|" + top, contextName, clazz, colVals);
        List<OBJTYPE> obj = this.m_cache.get(keyStr);
        if (obj != null) {
            return obj;
        }
        obj = DOFWSql.queryTop(contextName, clazz, top, colVals);
        this.m_cache.put(keyStr, obj);
        return obj;
    }

    private String generateCacheKey(String usage, String contextName, Class<?> clazz, Object ... colVals) {
        StringBuilder key = new StringBuilder();
        key.append(usage).append('|').append(contextName).append('|').append(clazz.getName());
        for (Object o : colVals) {
            key.append('|').append(o);
        }
        return key.toString();
    }
}

