/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.dofw;

import java.util.HashMap;
import java.util.Map;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.bridges.ClassLoaderBridge;
import org.eclnt.ccee.config.Config;
import org.eclnt.ccee.db.IDBConnectionProvider;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.jsfserver.managedbean.DefaultHotDeployListener;
import org.eclnt.jsfserver.managedbean.HotDeployNotifier;
import org.eclnt.jsfserver.managedbean.IHotDeployListener;

public class DBConnectionProviderManager
implements ICCEEConstants {
    static final Object SYNCHER = new Object();
    static final Map<String, IDBConnectionProvider> s_connectionProviders = new HashMap<String, IDBConnectionProvider>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDBConnectionProvider findDBConnectionProvider(String contextName) {
        String connectionProviderClassName = Config.getConfigValue(contextName, "db_connectionproviderclassname");
        if (connectionProviderClassName == null || connectionProviderClassName.length() == 0) {
            return null;
        }
        try {
            IDBConnectionProvider provider = null;
            Object object = SYNCHER;
            synchronized (object) {
                provider = s_connectionProviders.get(contextName);
            }
            if (provider == null) {
                object = SYNCHER;
                synchronized (object) {
                    provider = s_connectionProviders.get(contextName);
                    if (provider == null) {
                        Class<?> providerClass = Class.forName(connectionProviderClassName, true, ClassLoaderBridge.findCurrentClassLoader());
                        provider = (IDBConnectionProvider)providerClass.newInstance();
                        s_connectionProviders.put(contextName, provider);
                    }
                }
            }
            return provider;
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Problem accesing connection provider " + connectionProviderClassName, t);
            throw new Error(t);
        }
    }

    static {
        HotDeployNotifier.addListener((IHotDeployListener)new DefaultHotDeployListener(){

            public void onClassLoaderUpdate(ClassLoader newClassLoader) {
                s_connectionProviders.clear();
            }
        });
    }
}

