/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.dofw;

import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.config.Config;
import org.eclnt.ccee.db.IDBConnectionProvider;
import org.eclnt.ccee.db.dofw.DBConnectionProviderManager;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class DOFWDialect
implements ICCEEConstants {
    static final int SELECTTOP_TOP = 0;
    static final int SELECTTOP_LIMIT = 1;
    static final int SELECTTOP_FETCHFIRST = 2;
    static final int SELECTTOP_ROWNUM = 3;
    public static final String DIALECT_POSTGRES = "postgres";
    public static final String DIALECT_MSSQL = "mssql";
    public static final String DIALECT_ORACLE = "oracle";
    public static final String DIALECT_ORACLE_CASESENSITIVE = "oracle_casesensitive";
    public static final String DIALECT_MYSQL = "mysql";
    public static final String DIALECT_SYBASE = "sybase";
    public static final String DIALECT_HSQLDB = "hsqldb";
    private static final String[] OBJECT_EXISTS_MESSAGE_PATTERNS = new String[]{"already;exists", "bereits;vorhanden", "existiert;bereits", "duplicate", "already;used"};
    public static final String[] ALL_DIALECTS = new String[]{"postgres", "mssql", "oracle", "oracle_casesensitive", "mysql", "sybase", "hsqldb"};

    public static int getSelectTopVariant(String contextName) {
        String dialect = DOFWDialect.findSqlDialect(contextName);
        if (dialect == null) {
            dialect = DIALECT_POSTGRES;
        }
        if (DIALECT_POSTGRES.equals(dialect)) {
            return 1;
        }
        if (DIALECT_MSSQL.equals(dialect)) {
            return 0;
        }
        if (DIALECT_ORACLE.equals(dialect)) {
            return 3;
        }
        if (DIALECT_ORACLE_CASESENSITIVE.equals(dialect)) {
            return 3;
        }
        if (DIALECT_MYSQL.equals(dialect)) {
            return 1;
        }
        if (DIALECT_SYBASE.equals(dialect)) {
            return 0;
        }
        if (DIALECT_HSQLDB.equals(dialect)) {
            return 1;
        }
        return 0;
    }

    public static String updateColumnNameForTextConversion(String contextName, String columnName) {
        String dialect = DOFWDialect.findSqlDialect(contextName);
        if (dialect == null) {
            dialect = DIALECT_POSTGRES;
        }
        if (DIALECT_POSTGRES.equals(dialect)) {
            return columnName + "::text";
        }
        if (DIALECT_ORACLE.equals(dialect)) {
            return "to_char(" + columnName + ")";
        }
        if (DIALECT_ORACLE_CASESENSITIVE.equals(dialect)) {
            return "to_char(" + columnName + ")";
        }
        if (DIALECT_HSQLDB.equals(dialect)) {
            return "TO_CHAR(" + columnName + ")";
        }
        return "CAST(" + columnName + " as VARCHAR)";
    }

    public static void approveDialectIsOK(String dialect) {
        if (dialect == null) {
            return;
        }
        for (String d : ALL_DIALECTS) {
            if (!dialect.equals(d)) continue;
            return;
        }
        AppLog.L.log(LL_ERR, "The dialect does not exist: " + dialect);
        AppLog.L.log(LL_ERR, "The dialects supported are: " + ALL_DIALECTS);
        throw new Error("The dialect does not exist: " + dialect);
    }

    public static String getColumnNameSurrounder(String contextName) {
        String dialect = DOFWDialect.findSqlDialect(contextName);
        if (dialect != null && dialect.equals(DIALECT_MYSQL)) {
            return "`";
        }
        if (dialect != null && dialect.equals(DIALECT_ORACLE_CASESENSITIVE)) {
            return "\"";
        }
        return null;
    }

    public static String getTableNameSurrounder(String contextName) {
        String dialect = DOFWDialect.findSqlDialect(contextName);
        if (dialect != null && dialect.equals(DIALECT_ORACLE_CASESENSITIVE)) {
            return "\"";
        }
        return null;
    }

    public static boolean checkIfUUIDIsRepresentedAsString(String contextName) {
        String dialect = DOFWDialect.findSqlDialect(contextName);
        if (dialect != null && dialect.equals(DIALECT_ORACLE)) {
            return true;
        }
        return dialect != null && dialect.equals(DIALECT_ORACLE_CASESENSITIVE);
    }

    public static String getFixColumnNameForAutoIncrementedColumns(String contextName) {
        String dialect = DOFWDialect.findSqlDialect(contextName);
        if (dialect != null && dialect.equals(DIALECT_MYSQL)) {
            return "GENERATED_KEY";
        }
        return null;
    }

    public static boolean getAutoIncrementGetValueSupported(String contextName) {
        String dialect = DOFWDialect.findSqlDialect(contextName);
        return dialect == null || !dialect.equals(DIALECT_HSQLDB);
    }

    public static String adaptTableCreationStatement(String contextName, String sql) {
        if (sql == null) {
            return null;
        }
        String dialect = DOFWDialect.findSqlDialect(contextName);
        if (DIALECT_HSQLDB.equals(dialect)) {
            sql = sql.replace(" bytea,", " longvarbinary,");
            if ((sql = sql.replace(" text,", " longvarchar,")).endsWith(" text")) {
                sql = sql.substring(0, sql.length() - " text".length()) + " longvarchar";
            }
            if (sql.endsWith(" bytea")) {
                sql = sql.substring(0, sql.length() - " bytea".length()) + " longvarbinary";
            }
        }
        return sql;
    }

    public static String findSqlDialect(String contextName) {
        String dialect = null;
        IDBConnectionProvider connectionProvider = DBConnectionProviderManager.findDBConnectionProvider(contextName);
        if (connectionProvider != null && (dialect = connectionProvider.getSQLDialect(contextName)) != null) {
            return dialect;
        }
        dialect = Config.getConfigValue(contextName, "db_sqldialect");
        if (dialect != null) {
            return dialect;
        }
        String driverNameLC = ValueManager.toLowerCaseId((String)Config.getConfigValue("db_driver"));
        if (driverNameLC != null) {
            if (driverNameLC.contains("sqlserver")) {
                dialect = DIALECT_MSSQL;
            } else if (driverNameLC.contains(DIALECT_ORACLE)) {
                dialect = DIALECT_ORACLE;
            } else if (driverNameLC.contains("maria")) {
                dialect = DIALECT_MYSQL;
            } else if (driverNameLC.contains(DIALECT_MYSQL)) {
                dialect = DIALECT_MYSQL;
            } else if (driverNameLC.contains("hsql")) {
                dialect = DIALECT_HSQLDB;
            }
        }
        if (dialect != null) {
            return dialect;
        }
        return DIALECT_POSTGRES;
    }

    public static boolean checkIfRangeSelectionIsSupported(String contextName) {
        int selectOffsetVariant = DOFWDialect.getSelectTopVariant(contextName);
        return selectOffsetVariant == 1;
    }

    public static boolean checkIfSQLErrorDueToAlreadyExistingObject(Throwable exc) {
        String message = ValueManager.toLowerCaseText((String)exc.getMessage());
        if (message != null) {
            for (String pattern : OBJECT_EXISTS_MESSAGE_PATTERNS) {
                String[] tokens;
                boolean foundAll = true;
                for (String token : tokens = ValueManager.decodeCSV((String)pattern)) {
                    if (message.contains(token)) continue;
                    foundAll = false;
                    break;
                }
                if (!foundAll) continue;
                return true;
            }
        }
        return false;
    }
}

