/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.dofw;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.util.log.PLog;

public class DOFWExecutor {
    static final String TYPE_UPDATE = "update";
    static final String TYPE_QUERYDURATION = "queryDuration";
    static final String TYPE_QUERYCOUNT = "queryCount";
    static DOFWExecutor s_instance = new DOFWExecutor();

    public static void initialize(DOFWExecutor instance) {
        s_instance = instance;
    }

    public static DOFWExecutor instance() {
        return s_instance;
    }

    public int executeUpdate(PreparedStatement ps) throws SQLException {
        long timeStampExecuteUpdateStart = System.currentTimeMillis();
        int resi = ps.executeUpdate();
        this.recordInfo(TYPE_UPDATE, timeStampExecuteUpdateStart);
        return resi;
    }

    public ResultSet executeQuery(PreparedStatement ps) throws SQLException {
        long timeStampExecuteUpdateStart = System.currentTimeMillis();
        ResultSet rs = ps.executeQuery();
        this.recordInfo(TYPE_QUERYDURATION, timeStampExecuteUpdateStart);
        PLog.accumulateNumberInCurrentRequest((String)"DOFWSql.queryCount", (long)1L);
        return rs;
    }

    protected void recordInfo(String type, long timeStampStart) {
        long duration = System.currentTimeMillis() - timeStampStart;
        AppLog.L.log(AppLog.LL_INF, "SQL: " + type + ": Execution time (ms): " + duration);
    }
}

