/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.dofw.trace;

import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.config.Config;
import org.eclnt.ccee.db.dofw.trace.ITrace;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.jsfserver.managedbean.DefaultHotDeployListener;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.managedbean.HotDeployNotifier;
import org.eclnt.jsfserver.managedbean.IHotDeployListener;

public class Trace
implements ICCEEConstants {
    private static final Object SYNCHER = new Object();
    private static boolean s_initialized = false;
    private static ITrace s_instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITrace instance() {
        if (!s_initialized) {
            Object object = SYNCHER;
            synchronized (object) {
                if (!s_initialized) {
                    String className = Config.getConfigValue("db_traceclassname");
                    AppLog.L.log(LL_INF, "Initializing trace management, className: " + className);
                    if (className != null) {
                        try {
                            Class<?> c = Class.forName(className, true, HotDeployManager.currentClassLoader());
                            AppLog.L.log(LL_INF, "Class of trace implementation is available: " + className);
                            s_instance = (ITrace)c.newInstance();
                            s_initialized = true;
                        }
                        catch (Throwable t) {
                            throw new Error("Could not create instance of DB-trace implementation: " + className, t);
                        }
                    }
                }
            }
        }
        return s_instance;
    }

    static {
        HotDeployNotifier.addListener((IHotDeployListener)new DefaultHotDeployListener(){

            public void onClassLoaderUpdateFinished(ClassLoader newClassLoader) {
                s_initialized = false;
                s_instance = null;
            }
        });
    }
}

