/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.facade;

import java.io.Serializable;
import org.eclnt.ccee.facade.FacadeClientException;
import org.eclnt.ccee.facade.FacadeServerException;
import org.eclnt.ccee.facade.FacadeTransferObjectReceive;
import org.eclnt.ccee.facade.FacadeTransferObjectSend;
import org.eclnt.ccee.facade.IFacadeTransfer;
import org.eclnt.ccee.util.SerializationUtil;

public class FacadeClient {
    IFacadeTransfer m_transfer;

    public FacadeClient(IFacadeTransfer transfer) {
        this.m_transfer = transfer;
    }

    public Object callFacadeMethod(String facadeClassName, String methodName, Class[] parameterClases, Serializable[] parameters) throws FacadeServerException, Throwable {
        try {
            FacadeTransferObjectSend fto = new FacadeTransferObjectSend();
            fto.setFacadeClassName(facadeClassName);
            fto.setMethodName(methodName);
            String[] classNames = FacadeClient.transferClassesToClassNames(parameterClases);
            byte[][] parameterContents = FacadeClient.transferObjectsToBytes(parameters);
            fto.setParameterClassNames(null);
            fto.setMethodName(methodName);
            fto.setParameterClassNames(classNames);
            fto.setParameters(parameterContents);
            FacadeTransferObjectReceive result = this.m_transfer.callFacade(fto);
            if (result.getException() != null) {
                FacadeServerException fe = (FacadeServerException)SerializationUtil.deserialize(result.getException());
                throw fe;
            }
            Object resultObject = SerializationUtil.deserialize(result.getResult());
            return resultObject;
        }
        catch (Throwable t) {
            if (t instanceof FacadeServerException) {
                throw ((FacadeServerException)t).getApplicationException();
            }
            throw new FacadeClientException(t);
        }
    }

    private static byte[][] transferObjectsToBytes(Serializable[] parameters) {
        if (parameters == null) {
            return null;
        }
        byte[][] result = new byte[parameters.length][];
        int counter = 0;
        for (Serializable object : parameters) {
            byte[] bytes = SerializationUtil.serialize(object);
            result[counter] = bytes;
            ++counter;
        }
        return result;
    }

    private static String[] transferClassesToClassNames(Class[] classes) {
        if (classes == null) {
            return null;
        }
        String[] result = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            result[i] = classes[i].getName();
        }
        return result;
    }
}

