/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.facade;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.facade.FacadeServerException;
import org.eclnt.ccee.facade.FacadeTransferObjectReceive;
import org.eclnt.ccee.facade.FacadeTransferObjectSend;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.util.SerializationUtil;

public class FacadeServer
implements ICCEEConstants {
    static ClassLoader s_classLoader = FacadeServer.class.getClassLoader();

    public static ClassLoader getClassLoader() {
        return s_classLoader;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        s_classLoader = classLoader;
    }

    public static FacadeTransferObjectReceive callFacadeMethod(FacadeTransferObjectSend sendInfo) {
        FacadeTransferObjectReceive result = new FacadeTransferObjectReceive();
        try {
            byte[] resultBytes = FacadeServer.callFacadeMethod(sendInfo.getFacadeClassName(), sendInfo.getMethodName(), sendInfo.getParameterClassNames(), sendInfo.getParameters());
            result.setResult(resultBytes);
        }
        catch (FacadeServerException t) {
            result.setException(SerializationUtil.serialize(t));
        }
        return result;
    }

    public static byte[] callFacadeMethod(String facadeClassName, String methodName, String[] parameterClassNames, byte[][] parameterBytes) throws FacadeServerException {
        try {
            AppLog.L.log(LL_INF, "Executing facade method call: " + facadeClassName + ":" + methodName);
            Class<?> c = Class.forName(facadeClassName, true, s_classLoader);
            Class[] parameterClasses = FacadeServer.transferClassNamesToClasses(parameterClassNames);
            Object[] parameterObjects = FacadeServer.transferBytesIntoObjects(parameterBytes);
            Method m = c.getMethod(methodName, parameterClasses);
            Serializable result = (Serializable)m.invoke(null, parameterObjects);
            return SerializationUtil.serialize(result);
        }
        catch (Throwable t) {
            AppLog.L.log(LL_INF, "Exception during facade execution: " + t.toString());
            throw new FacadeServerException(t);
        }
    }

    private static Object[] transferBytesIntoObjects(byte[][] parameterBytes) {
        if (parameterBytes == null) {
            return null;
        }
        Object[] result = new Object[parameterBytes.length];
        for (int i = 0; i < parameterBytes.length; ++i) {
            result[i] = SerializationUtil.deserialize(parameterBytes[i]);
        }
        return result;
    }

    private static Class[] transferClassNamesToClasses(String[] classNames) throws ClassNotFoundException {
        if (classNames == null) {
            return null;
        }
        Class[] result = new Class[classNames.length];
        int counter = 0;
        for (String className : classNames) {
            result[counter] = Class.forName(className, true, s_classLoader);
            ++counter;
        }
        return result;
    }
}

