/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.http;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.file.StreamUtil;

public class HttpDataTransfer {
    public static String readUrlContentAsUTF8String(String urlString, boolean withError) {
        return HttpDataTransfer.readUrlContentAsUTF8String(urlString, null, null, withError);
    }

    public static String readUrlContentAsUTF8String(String urlString, String userName, String password, boolean withError) {
        try {
            byte[] bytes = HttpDataTransfer.readURLContent(urlString, userName, password, true);
            String result = new String(bytes, "UTF-8");
            return result;
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem reading from urlString: " + urlString);
            }
            return null;
        }
    }

    public static byte[] readURLContent(String urlString, boolean withError) {
        return HttpDataTransfer.readURLContent(urlString, null, null, withError);
    }

    public static byte[] readURLContent(String urlString, String userName, String password, boolean withError) {
        try {
            if (!urlString.startsWith("file:")) {
                return HttpDataTransfer.readURLContentHttp(urlString, userName, password);
            }
            return HttpDataTransfer.readURLContentFile(urlString);
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem reading data from URL: " + urlString, t);
            }
            return null;
        }
    }

    private static byte[] readURLContentFile(String urlString) {
        String fileName = urlString.substring("file://".length());
        return FileManager.readFile((String)fileName, (boolean)true);
    }

    private static byte[] readURLContentHttp(String urlString, String userName, String password) throws Exception {
        URL url = new URL(urlString);
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        if (userName != null) {
            byte[] authEncBytes = Base64.getEncoder().encode((userName + ":" + password).getBytes());
            String authStringEnc = new String(authEncBytes);
            conn.setRequestProperty("Authorization", "Basic " + authStringEnc);
        }
        InputStream is = conn.getInputStream();
        byte[] result = StreamUtil.transferStreamContentIntoBytes((InputStream)is);
        return result;
    }
}

