/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.json.jackson;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Map;

public class JSONUtil {
    public static <TYPE> TYPE unmarshalSimpleObject(String json, Class<TYPE> clazz) {
        try {
            ObjectMapper mapper = JSONUtil.createMapper();
            Object result = mapper.readValue(json, clazz);
            return (TYPE)result;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static <TYPE> TYPE unmarshalSimpleObject(String json, TypeReference<TYPE> typeReference) {
        try {
            ObjectMapper mapper = JSONUtil.createMapper();
            Object result = mapper.readValue(json, typeReference);
            return (TYPE)result;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static String marshalSimpleObject(Object o) {
        try {
            ObjectMapper mapper = JSONUtil.createMapper();
            String result = mapper.writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValueAsString(o);
            return result;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static Map<String, Object> unmarshalMap(String json) {
        return JSONUtil.unmarshalSimpleObject(json, Map.class);
    }

    public static String marshalMap(Map<String, Object> map) {
        return JSONUtil.marshalSimpleObject(map);
    }

    private static ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());
        return mapper;
    }
}

