/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;

public class QRCodeCreator {
    public static byte[] generateQRCodePNG(String barcodeText, int width, int height) {
        try {
            BufferedImage bim = QRCodeCreator.generateQRCodeImage(barcodeText, width, height);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bim, "jpg", bos);
            return bos.toByteArray();
        }
        catch (Throwable t) {
            throw new Error("Problem creating QR Code for text: " + barcodeText, t);
        }
    }

    public static BufferedImage generateQRCodeImage(String barcodeText, int width, int height) {
        try {
            QRCodeWriter barcodeWriter = new QRCodeWriter();
            BitMatrix bitMatrix = barcodeWriter.encode(barcodeText, BarcodeFormat.QR_CODE, width, height);
            return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        }
        catch (Throwable t) {
            throw new Error("Problem creating QR Code for text: " + barcodeText, t);
        }
    }
}

