/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclnt.util.buffermgmt.IResetBuffer;
import org.eclnt.util.buffermgmt.ResetBuffers;

public class PojoUtil {
    private static final Object SYNCHER = new Object();
    static Map<Class, Map<String, PropertyDescriptor>> s_propertyDescriptors = new Hashtable<Class, Map<String, PropertyDescriptor>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetBuffers() {
        Object object = SYNCHER;
        synchronized (object) {
            s_propertyDescriptors.clear();
        }
    }

    public static Object getPropertyValue(Object bean, String propertyName) {
        try {
            PropertyDescriptor pd = PojoUtil.findPropertyDescriptor(bean.getClass(), propertyName);
            Method getter = pd.getReadMethod();
            return getter.invoke(bean, new Object[0]);
        }
        catch (Throwable t) {
            throw new Error("Problem accessing: " + bean.getClass().getName() + ", " + propertyName, t);
        }
    }

    public static void setPropertyValue(Object bean, String propertyName, Object value) {
        try {
            Map<String, PropertyDescriptor> pds = s_propertyDescriptors.get(bean.getClass());
            if (pds == null) {
                PojoUtil.analyzeBean(bean.getClass());
                pds = s_propertyDescriptors.get(bean.getClass());
            }
            PropertyDescriptor pd = PojoUtil.findPropertyDescriptor(bean.getClass(), propertyName);
            Method setter = pd.getWriteMethod();
            setter.invoke(bean, value);
        }
        catch (Throwable t) {
            throw new Error("Problem setting: " + bean.getClass().getName() + ", " + propertyName + ", " + value, t);
        }
    }

    public static void moveCorresponding(Object beanFrom, Object beanTo) {
        try {
            if (beanFrom == null) {
                return;
            }
            if (beanTo == null) {
                return;
            }
            Map<String, PropertyDescriptor> fromPds = PojoUtil.findPropertyDescriptors(beanFrom.getClass());
            Map<String, PropertyDescriptor> toPds = PojoUtil.findPropertyDescriptors(beanTo.getClass());
            for (PropertyDescriptor fromPd : fromPds.values()) {
                PropertyDescriptor toPd = toPds.get(fromPd.getName());
                if (toPd == null) continue;
                Class<?> fromClass = fromPd.getPropertyType();
                Class<?> toClass = toPd.getPropertyType();
                if (!toClass.isAssignableFrom(fromClass)) continue;
                Method getter = fromPd.getReadMethod();
                Method setter = toPd.getWriteMethod();
                if (getter == null || setter == null) continue;
                Object value = getter.invoke(beanFrom, new Object[0]);
                setter.invoke(beanTo, value);
            }
        }
        catch (Throwable t) {
            throw new Error("Problem during moveCorresponding: " + beanFrom + ", " + beanTo, t);
        }
    }

    private static Map<String, PropertyDescriptor> findPropertyDescriptors(Class clazz) {
        Map<String, PropertyDescriptor> pdsMap = s_propertyDescriptors.get(clazz);
        if (pdsMap == null) {
            PojoUtil.analyzeBean(clazz);
            pdsMap = s_propertyDescriptors.get(clazz);
        }
        return pdsMap;
    }

    private static PropertyDescriptor findPropertyDescriptor(Class clazz, String propertyName) {
        Map<String, PropertyDescriptor> pdsMap = PojoUtil.findPropertyDescriptors(clazz);
        PropertyDescriptor pd = pdsMap.get(propertyName);
        if (pd == null) {
            throw new Error("Could not find property descriptor for: " + clazz.getName() + ", " + propertyName);
        }
        return pd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void analyzeBean(Class clazz) {
        if (s_propertyDescriptors.containsKey(clazz)) {
            return;
        }
        Object object = SYNCHER;
        synchronized (object) {
            if (s_propertyDescriptors.containsKey(clazz)) {
                return;
            }
            try {
                BeanInfo bi = Introspector.getBeanInfo(clazz);
                PropertyDescriptor[] pds = bi.getPropertyDescriptors();
                HashMap<String, PropertyDescriptor> pdsMap = new HashMap<String, PropertyDescriptor>();
                for (PropertyDescriptor pd : pds) {
                    pdsMap.put(pd.getName(), pd);
                }
                s_propertyDescriptors.put(clazz, pdsMap);
            }
            catch (Throwable t) {
                throw new Error("Problem during Analysis of bean class: " + clazz.getName());
            }
        }
    }

    static {
        ResetBuffers.addListenerClassSwap((IResetBuffer)new IResetBuffer(){

            public void reset() {
                PojoUtil.resetBuffers();
            }
        });
    }
}

