/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.chatgpt.logic.conversation;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclnt.ccee.chatgpt.logic.conversation.ILMContext;
import org.eclnt.ccee.chatgpt.logic.conversation.ILMConversation;
import org.eclnt.ccee.chatgpt.logic.conversation.ILMConversationListener;

public abstract class LMConversationBase
implements ILMConversation {
    Set<ILMConversationListener> m_listeners = new HashSet<ILMConversationListener>();
    ILMContext m_context;
    Stack<String> m_contentStack = new Stack();

    @Override
    public void initialize(ILMContext context) {
        if (context == null) {
            throw new Error("Context must not be null");
        }
        this.m_context = context;
    }

    @Override
    public void addListener(ILMConversationListener listener) {
        this.m_listeners.add(listener);
    }

    @Override
    public void removeListener(ILMConversationListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public void start(String initialText) {
        this.m_contentStack.push(initialText);
    }

    @Override
    public String getCurrentContent() {
        if (this.m_contentStack.size() == 0) {
            return null;
        }
        return this.m_contentStack.peek();
    }

    protected ILMContext getLMContext() {
        return this.m_context;
    }

    protected void addNewContent(String text) {
        this.m_contentStack.push(text);
        for (ILMConversationListener listener : this.m_listeners) {
            listener.onConversationUpdated();
        }
    }
}

