/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.chatgpt.logic.conversation;

import org.eclnt.ccee.chatgpt.logic.conversation.ENUMLMCommand;
import org.eclnt.ccee.chatgpt.logic.conversation.ILMContext;
import org.eclnt.ccee.chatgpt.logic.conversation.LMContextChatGPT;
import org.eclnt.ccee.chatgpt.logic.conversation.LMConversationBase;
import org.eclnt.ccee.chatgpt.logic.http.HttpCommunicationChatGPT;
import org.eclnt.ccee.chatgpt.logic.http.OpenAIJson;

public class LMConversationChatGPT
extends LMConversationBase {
    String m_threadId;
    String m_currentRunId;

    @Override
    public void initialize(ILMContext context) {
        super.initialize(context);
        if (!(context instanceof LMContextChatGPT)) {
            throw new Error("Wrong context class: must be " + LMContextChatGPT.class.getName() + " but is " + context.getClass().getName());
        }
    }

    @Override
    public void start(String initialText) {
        super.start(initialText);
        this.createThread();
        this.createMessage(initialText);
        this.createRun();
        this.waitForRunResult();
    }

    @Override
    public void executeCommand(ENUMLMCommand command, String text) {
        this.createMessage(text);
        this.createRun();
        this.waitForRunResult();
    }

    private LMContextChatGPT getContextChatGPT() {
        return (LMContextChatGPT)this.getLMContext();
    }

    private void createThread() {
        String response = HttpCommunicationChatGPT.instance().doPost("https://api.openai.com/v1/threads", null, null);
        this.m_threadId = OpenAIJson.instance().parseThreadsResponseForId(response);
    }

    private void createMessage(String initialText) {
        String createMessageRequest = OpenAIJson.instance().createThreadMessage("user", initialText);
        HttpCommunicationChatGPT.instance().doPost("https://api.openai.com/v1/threads/" + this.m_threadId + "/messages", createMessageRequest, null);
    }

    private void createRun() {
        if (this.m_currentRunId != null) {
            throw new Error("Currently processing! Parallel processing not possible.");
        }
        String createRunRequest = OpenAIJson.instance().createRunMessage(this.getContextChatGPT().getAssistantId(), false);
        String response = HttpCommunicationChatGPT.instance().doPost("https://api.openai.com/v1/threads/" + this.m_threadId + "/runs", createRunRequest, null);
        this.m_currentRunId = (String)OpenAIJson.instance().parseMessageResponse(response).get("id");
    }

    private void waitForRunResult() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                LMConversationChatGPT.this.waitForRunResultInAsyncThread();
            }
        };
        new Thread(r).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForRunResultInAsyncThread() {
        try {
            for (int i = 0; i < 100; ++i) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                String response = HttpCommunicationChatGPT.instance().doGet("https://api.openai.com/v1/threads/" + this.m_threadId + "/runs/" + this.m_currentRunId, null);
                String status = (String)OpenAIJson.instance().parseMessageResponse(response).get("status");
                System.out.println("Status: " + status);
                if (!"completed".equals(status)) continue;
                this.m_currentRunId = null;
                this.readAndUpdateCurrentTextinAsnycThread();
                return;
            }
        }
        finally {
            this.m_currentRunId = null;
        }
        throw new Error("Missing completion");
    }

    private void readAndUpdateCurrentTextinAsnycThread() {
        String response = HttpCommunicationChatGPT.instance().doGet("https://api.openai.com/v1/threads/" + this.m_threadId + "/messages", null);
        String text = OpenAIJson.instance().parseMessagesResponseForText(response);
        this.addNewContent(text);
    }
}

