/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.dofw.finder;

import java.util.ArrayList;
import java.util.List;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.db.dofw.DOFWProperty;
import org.eclnt.ccee.db.dofw.DOFWRepository;
import org.eclnt.ccee.db.dofw.DOFWSql;
import org.eclnt.ccee.db.dofw.finder.FI;
import org.eclnt.ccee.db.dofw.finder.FIKeyMapping;
import org.eclnt.ccee.db.dofw.finder.FIMapping;
import org.eclnt.ccee.db.dofw.finder.IFIMapping;
import org.eclnt.ccee.db.dofw.finder.IFindNext;
import org.eclnt.util.valuemgmt.PojoManager;

public class FindNextDOFW<TOCLASS>
implements IFindNext<TOCLASS>,
ICCEEConstants {
    protected Class<TOCLASS> m_toClass;
    protected IFIMapping m_mapping = null;

    public FindNextDOFW(Class<TOCLASS> toClass, IFIMapping mapping) {
        this.m_toClass = toClass;
        this.m_mapping = mapping;
    }

    @Override
    public TOCLASS find(Object fromInstance) {
        try {
            Object[] colVals = this.transferMappingIntoColVals(fromInstance);
            return DOFWSql.queryOne(this.m_toClass, colVals);
        }
        catch (Throwable t) {
            throw new Error("Could not access object of class: " + this.m_toClass.getName() + ", " + this.m_mapping, t);
        }
    }

    @Override
    public List<TOCLASS> findList(Object fromInstance) {
        try {
            Object[] colVals = this.transferMappingIntoColVals(fromInstance);
            return DOFWSql.query(this.m_toClass, colVals);
        }
        catch (Throwable t) {
            throw new Error("Could not access object of class: " + this.m_toClass.getName() + ", " + this.m_mapping, t);
        }
    }

    protected Object[] transferMappingIntoColVals(Object fromInstance) {
        if (this.m_mapping instanceof FIMapping) {
            return this.transferMappingIntoColValsFIMapping(fromInstance);
        }
        if (this.m_mapping instanceof FIKeyMapping) {
            return this.transferMappingIntoColValsFIKeyMapping(fromInstance);
        }
        throw new Error("Unsupported IFIMapping: " + this.m_mapping);
    }

    protected Object[] transferMappingIntoColValsFIMapping(Object fromInstance) {
        FIMapping mapping = (FIMapping)this.m_mapping;
        Object[] mappings = mapping.getMappings();
        if (mappings == null) {
            throw new Error("No mappings specified.");
        }
        if (mappings.length % 2 != 0) {
            throw new Error("Invalid number of mapping elements: " + mappings.length + ", must be even.");
        }
        ArrayList<Object> colVals = new ArrayList<Object>();
        for (int i = 0; i < mappings.length; i += 2) {
            if (colVals.size() > 0) {
                colVals.add("AND");
            }
            colVals.add(mappings[i + 1]);
            colVals.add("=");
            String propertyName = (String)mappings[i];
            Object propertyValue = PojoManager.getPropertyValue((Object)fromInstance, (String)propertyName);
            colVals.add(propertyValue);
        }
        return colVals.toArray(new Object[colVals.size()]);
    }

    protected Object[] transferMappingIntoColValsFIKeyMapping(Object fromInstance) {
        FIKeyMapping mapping = (FIKeyMapping)this.m_mapping;
        Object[] mappings = mapping.getMappings();
        if (mappings == null) {
            throw new Error("No mappings specified.");
        }
        List<DOFWProperty> keyProperties = DOFWRepository.getKeyPropertiesSorted(this.m_toClass);
        if (mappings.length != keyProperties.size()) {
            throw new Error("Invalid number of mapping elements: " + mappings.length + ", must match the number of key properties: " + keyProperties.size());
        }
        ArrayList<Object> colVals = new ArrayList<Object>();
        for (int i = 0; i < mappings.length; ++i) {
            String propertyNameTo = keyProperties.get(i).getName();
            String propertyNameFrom = (String)mappings[i];
            if (propertyNameFrom == FI.ALL) continue;
            Object propertyValueFrom = PojoManager.getPropertyValue((Object)fromInstance, (String)propertyNameFrom);
            if (colVals.size() > 0) {
                colVals.add("AND");
            }
            colVals.add(propertyNameTo);
            colVals.add("=");
            colVals.add(propertyValueFrom);
        }
        return colVals.toArray(new Object[colVals.size()]);
    }
}

