/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.dofw.util;

import java.sql.PreparedStatement;
import org.eclnt.ccee.db.DBAction;
import org.eclnt.ccee.db.dofw.DOFWEntity;
import org.eclnt.ccee.db.dofw.DOFWRepository;
import org.eclnt.ccee.db.dofw.util.DOFWUtils;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.util.mitigation.CCMitigation;

@CCMitigation(cweIds={"89"}, comment="This is the central class of the DOFW persistence framework. It maps Java entity objects (\"Pojos\") to database table operations. As result SQL commands are assembled for querying and updating the database.\nThe SQL commands are all assembled in the same way:\n1. PreparedStatement processing is used so that\n2. any data that is passed by the application is NOT able to influence the SQL command itself.\nAs result the framework is robust against SQL injection attacks.")
public class DOFWDatabaseAdmin {
    private static DOFWDatabaseAdmin s_instance = new DOFWDatabaseAdmin();

    public static DOFWDatabaseAdmin instance() {
        return s_instance;
    }

    public static void initialize(DOFWDatabaseAdmin instance) {
        s_instance = instance;
    }

    public void dropTable(Class beanClass) {
        this.dropTable("CCEE_DEFAULTCONTEXT", beanClass);
    }

    public void dropTable(final String contextName, final Class beanClass) {
        try {
            AppLog.L.log(AppLog.LL_INF, "Drop table is requested for bean class: " + beanClass.getName());
            new DBAction(contextName){

                @Override
                protected void run() throws Exception {
                    DOFWEntity entity = DOFWRepository.getEntity(beanClass);
                    String tableName = DOFWUtils.qut(contextName, this.withSchema(entity));
                    String sql = "DROP TABLE IF EXISTS @tableName@";
                    sql = sql.replace("@tableName@", tableName);
                    PreparedStatement ps = this.createStatement(sql);
                    ps.execute();
                }
            };
        }
        catch (Throwable t) {
            throw new Error("Problem occurred when processing dropTable: " + beanClass, t);
        }
    }
}

