/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.db.DBAction;
import org.eclnt.ccee.db.dofw.util.DOFWUtils;
import org.eclnt.ccee.db.util.QueryUtils;

public class JDBCSql
implements ICCEEConstants {
    public static Map<String, Object> queryOne(String tableName, Object[] colVals, Object[] orderBy) {
        return JDBCSql.queryOne("CCEE_DEFAULTCONTEXT", tableName, colVals, orderBy);
    }

    public static Map<String, Object> queryOne(String contextName, String tableName, Object[] colVals, Object[] orderBy) {
        List<Map<String, Object>> ms = JDBCSql.query(contextName, tableName, colVals, orderBy);
        if (ms.size() >= 1) {
            return ms.get(0);
        }
        return null;
    }

    public static List<Map<String, Object>> query(String tableName, Object[] colVals, Object[] oderBy) {
        return JDBCSql.query("CCEE_DEFAULTCONTEXT", tableName, colVals, oderBy);
    }

    public static List<Map<String, Object>> query(final String contextName, final String tableName, final Object[] colVals, final Object[] orderBy) {
        final ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                StringBuffer sb = new StringBuffer();
                sb.append("SELECT * FROM " + tableName);
                ArrayList columnIndices = new ArrayList();
                ArrayList valueIndices = new ArrayList();
                if (colVals != null && colVals.length > 0) {
                    sb.append(" WHERE ");
                    JDBCSql.buildConditionString(contextName, sb, tableName, colVals, columnIndices, valueIndices);
                }
                if (orderBy != null && orderBy.length > 0) {
                    JDBCSql.buildOrderByString(contextName, sb, orderBy);
                }
                int counter = 1;
                PreparedStatement ps = this.createStatement(sb.toString());
                JDBCSql.transferConditionValuesIntoResultSet(contextName, tableName, colVals, columnIndices, valueIndices, ps, counter);
                ResultSet rs = ps.executeQuery();
                JDBCSql.mapResultSetList(contextName, rs, tableName, result);
            }
        };
        return result;
    }

    public static void mapResultSetList(String contextName, ResultSet rs, String tableName, List<Map<String, Object>> dms) {
        try {
            while (rs.next()) {
                Map<String, Object> dm = JDBCSql.mapResultSet(contextName, rs, tableName);
                dms.add(dm);
            }
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    private static Map<String, Object> mapResultSet(String contextName, ResultSet rs, String tableName) throws SQLException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
            String colName = rs.getMetaData().getColumnName(i + 1);
            Object value = rs.getObject(i + 1);
            result.put(colName, value);
        }
        return result;
    }

    private static void buildConditionString(String contextName, StringBuffer sb, String tableName, Object[] colVals, List<Integer> columnIndices, List<Integer> valueIndices) {
        if (colVals == null) {
            colVals = new Object[]{};
        }
        boolean waitingForColumn = true;
        boolean waitingForValue = false;
        boolean waitingForLogic = false;
        boolean waitingForComparator = false;
        for (int i = 0; i < colVals.length; ++i) {
            Object colVal = colVals[i];
            if (QueryUtils.checkIfObjectIsQueryLogic(colVal)) {
                sb.append(" " + colVal);
                waitingForColumn = true;
                waitingForComparator = false;
                waitingForValue = false;
                waitingForLogic = false;
                continue;
            }
            if (QueryUtils.checkIfObjectIsSQLComparator(colVal)) {
                try {
                    Object nextColVal = colVals[i + 1];
                    if (colVal == "=" && (nextColVal == "CCEE_NULL" || nextColVal == null)) {
                        colVal = "IS";
                    }
                    if (colVal == "<>" && (nextColVal == "CCEE_NULL" || nextColVal == null)) {
                        colVal = "IS NOT";
                    }
                }
                catch (Throwable nextColVal) {
                    // empty catch block
                }
                sb.append(" " + colVal);
                waitingForColumn = false;
                waitingForComparator = false;
                waitingForValue = true;
                waitingForLogic = false;
                continue;
            }
            if (waitingForColumn) {
                if (waitingForLogic) {
                    sb.append(" AND ");
                }
                String propertyName = null;
                if (!(colVal instanceof String)) {
                    throw new Error("Expecting String or QueryParameterFunction as class, but have: " + colVal.toString());
                }
                propertyName = colVal.toString();
                String colName = propertyName;
                sb.append(" " + JDBCSql.quc(contextName, colName));
                columnIndices.add(i);
                waitingForColumn = false;
                waitingForComparator = true;
                waitingForValue = false;
                waitingForLogic = false;
                continue;
            }
            if (waitingForValue) {
                if (colVal != "CCEE_NULL" && colVal != null) {
                    sb.append(" ?");
                    valueIndices.add(i);
                } else {
                    sb.append(" NULL");
                    valueIndices.add(null);
                }
                waitingForColumn = true;
                waitingForComparator = false;
                waitingForValue = false;
                waitingForLogic = true;
                continue;
            }
            if (!waitingForComparator || QueryUtils.checkIfObjectIsSQLComparator(colVal)) continue;
            if (colVal != "CCEE_NULL" && colVal != null) {
                sb.append(" =?");
                valueIndices.add(i);
            } else {
                sb.append(" IS NULL");
                valueIndices.add(null);
            }
            waitingForColumn = true;
            waitingForComparator = false;
            waitingForValue = false;
            waitingForLogic = true;
        }
    }

    private static void buildOrderByString(String contextName, StringBuffer sb, Object[] orderBy) {
        if (orderBy == null) {
            return;
        }
        if (orderBy.length == 0) {
            return;
        }
        sb.append(" ORDER BY");
        boolean firstColumnApplied = false;
        for (Object order : orderBy) {
            if (QueryUtils.checkIfObjectIsOrderByInstrcution(order)) {
                sb.append(" " + order);
                continue;
            }
            if (firstColumnApplied) {
                sb.append(" ,");
            }
            sb.append(" " + JDBCSql.quc(contextName, order.toString()));
            firstColumnApplied = true;
        }
    }

    private static void transferConditionValuesIntoResultSet(String contextName, String tableName, Object[] colVals, List<Integer> columnIndices, List<Integer> valueIndices, PreparedStatement ps, int psParamCounter) throws Exception {
        for (int i = 0; i < columnIndices.size(); ++i) {
            if (columnIndices.get(i) == null || valueIndices.get(i) == null) continue;
            String colName = "" + colVals[columnIndices.get(i)];
            Object colValue = colVals[valueIndices.get(i)];
            JDBCSql.psSetValue(contextName, ps, colName, colValue, psParamCounter++);
        }
    }

    private static void psSetValue(String contextName, PreparedStatement ps, String colName, Object colValue, int counter) {
        try {
            ps.setObject(counter, colValue);
        }
        catch (Throwable t) {
            throw new Error("Could not set value into prepared statement: " + colName + ", " + colValue, t);
        }
    }

    private static String quc(String contextName, String columnName) {
        return DOFWUtils.quc(contextName, columnName);
    }
}

