/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class QueryUtils
implements ICCEEConstants {
    public static boolean checkIfObjectIsQueryLogic(Object o) {
        if (o == "AND") {
            return true;
        }
        if (o == "OR") {
            return true;
        }
        if (o == "(") {
            return true;
        }
        return o == ")";
    }

    public static boolean checkIfObjectIsOrderByInstrcution(Object o) {
        if (o == "ASC") {
            return true;
        }
        return o == "DESC";
    }

    public static boolean checkIfObjectIsSQLComparator(Object o) {
        if (o == "=") {
            return true;
        }
        if (o == "<>") {
            return true;
        }
        if (o == "LIKE") {
            return true;
        }
        if (o == ">") {
            return true;
        }
        if (o == ">=") {
            return true;
        }
        if (o == "<") {
            return true;
        }
        if (o == "<=") {
            return true;
        }
        if (o == "IN") {
            return true;
        }
        return o == "BETWEEN";
    }

    public static Object[] transferSortStringIntoQueryObjects(String[] orderBy) {
        if (orderBy == null) {
            return null;
        }
        Object[] result = new Object[orderBy.length];
        int counter = 0;
        for (String token : orderBy) {
            result[counter] = "ASC".equals(token) ? "ASC" : ("DESC".equals(token) ? "DESC" : token);
            ++counter;
        }
        return result;
    }

    public static Object[] transferSortStringIntoQueryObjects(String orderBy) {
        if (orderBy != null) {
            String[] tokens = QueryUtils.transferSpacedStringIntoTokens(orderBy);
            return QueryUtils.transferSortStringIntoQueryObjects(tokens);
        }
        return null;
    }

    public static Object[] transferQueryStringIntoQueryObjects(String structureName, String[] query, IValueClassProvider valueClassProvider) {
        ArrayList<Object> os = new ArrayList<Object>();
        String tokenBefore = null;
        String tokenPropertyName = null;
        for (String token : query) {
            if ("IS".equals(ValueManager.toUpperCaseId((String)token)) || "=".equals(token)) {
                os.add("=");
                tokenPropertyName = tokenBefore;
            } else if ("<".equals(ValueManager.toUpperCaseId((String)token))) {
                os.add("<");
                tokenPropertyName = tokenBefore;
            } else if ("<=".equals(ValueManager.toUpperCaseId((String)token))) {
                os.add("<=");
                tokenPropertyName = tokenBefore;
            } else if (">".equals(ValueManager.toUpperCaseId((String)token))) {
                os.add(">");
                tokenPropertyName = tokenBefore;
            } else if (">=".equals(ValueManager.toUpperCaseId((String)token))) {
                os.add(">=");
                tokenPropertyName = tokenBefore;
            } else if ("ISNOT".equals(ValueManager.toUpperCaseId((String)token)) || "<>".equals(ValueManager.toUpperCaseId((String)token))) {
                os.add("<>");
                tokenPropertyName = tokenBefore;
            } else if ("!=".equals(ValueManager.toUpperCaseId((String)token))) {
                os.add("<>");
                tokenPropertyName = tokenBefore;
            } else if ("AND".equals(ValueManager.toUpperCaseId((String)token))) {
                os.add("AND");
            } else if ("OR".equals(ValueManager.toUpperCaseId((String)token))) {
                os.add("OR");
            } else if ("LIKE".equals(ValueManager.toUpperCaseId((String)token))) {
                os.add("LIKE");
                tokenPropertyName = tokenBefore;
            } else if ("(".equals(token)) {
                os.add("(");
            } else if (")".equals(token)) {
                os.add(")");
            } else if (tokenPropertyName != null) {
                if (token.startsWith("${")) {
                    os.add(token);
                } else {
                    try {
                        Class propertyClass = null;
                        if (propertyClass == null && (propertyClass = QueryUtils.findPropertyClassFromQueryValueString(token)) != null) {
                            token = QueryUtils.cutClassCastInfoFromValueString(token);
                        }
                        if (propertyClass == null) {
                            propertyClass = valueClassProvider.findTypeForProperty(structureName, tokenPropertyName);
                        }
                        Object value = ValueManager.convertStringIntoObject((String)token, (Class)propertyClass);
                        os.add(value);
                    }
                    catch (Throwable t) {
                        AppLog.L.log(LL_INF, "Problem finding attribute class for: " + structureName + " in " + query);
                        AppLog.L.log(LL_INF, "Will pass value as String value: " + token);
                        os.add(token);
                    }
                }
                tokenPropertyName = null;
            } else {
                os.add(token);
            }
            tokenBefore = token;
        }
        Object[] result = new Object[os.size()];
        os.toArray(result);
        return result;
    }

    public static Class findPropertyClassFromQueryValueString(String token) {
        if (token != null) {
            if (token.startsWith("(int)")) {
                return Integer.class;
            }
            if (token.startsWith("(long)")) {
                return Long.class;
            }
            if (token.startsWith("(float)")) {
                return Float.class;
            }
            if (token.startsWith("(double)")) {
                return Double.class;
            }
            if (token.startsWith("(BigDecimal)")) {
                return BigDecimal.class;
            }
        }
        return null;
    }

    public static String cutClassCastInfoFromValueString(String token) {
        int index = token.indexOf(41);
        token = token.substring(index + 1);
        return token;
    }

    public static Object[] transferQueryStringIntoQueryObjects(String structureName, String query, IValueClassProvider valueClassProvider) {
        if (query != null) {
            String[] tokens = QueryUtils.transferSpacedStringIntoTokens(query);
            return QueryUtils.transferQueryStringIntoQueryObjects(structureName, tokens, valueClassProvider);
        }
        return null;
    }

    private static String[] transferSpacedStringIntoTokens(String s) {
        ArrayList tokens = new ArrayList();
        if (s != null) {
            s = QueryUtils.cleanUpQueryStringBeforeExecution(s);
            return ValueManager.tokenizeStringWithQuotes((String)s, (char)' ');
        }
        String[] result = new String[tokens.size()];
        tokens.toArray(result);
        return result;
    }

    private static String cleanUpQueryStringBeforeExecution(String dofwQuery) {
        if (dofwQuery != null) {
            dofwQuery = dofwQuery.replace("\r", " ");
            dofwQuery = dofwQuery.replace("\n", " ");
            dofwQuery = dofwQuery.replace("\t", " ");
        }
        return dofwQuery;
    }

    public static Map<String, String> parseExecQuerySQLColumnsIntoAliasAndSqlName(String execQuerySQLColumns) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(execQuerySQLColumns, ",");
        while (st.hasMoreElements()) {
            String token = st.nextToken().trim();
            if (token.length() == 0) continue;
            int asIndex = token.indexOf(" as ");
            if (asIndex < 0) {
                asIndex = token.indexOf(" AS ");
            }
            if (asIndex < 0) continue;
            String fullName = token.substring(0, asIndex).trim();
            String alias = token.substring(asIndex + " AS ".length()).trim();
            result.put(alias, fullName);
        }
        return result;
    }

    public static interface IValueClassProvider {
        public Class findTypeForProperty(String var1, String var2);
    }
}

